/*
 * Decompiled with CFR 0.152.
 */
package io.github.m0pt0pmatt.survivalgames.command.executor;

import io.github.m0pt0pmatt.survivalgames.Util;
import io.github.m0pt0pmatt.survivalgames.command.CommandKeys;
import io.github.m0pt0pmatt.survivalgames.command.executor.LeafCommand;
import io.github.m0pt0pmatt.survivalgames.command.executor.RootCommand;
import java.util.Optional;
import javax.annotation.Nonnull;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.command.CommandException;
import org.spongepowered.api.command.CommandResult;
import org.spongepowered.api.command.CommandSource;
import org.spongepowered.api.command.args.CommandContext;
import org.spongepowered.api.command.args.CommandElement;
import org.spongepowered.api.command.args.GenericArguments;
import org.spongepowered.api.text.Text;

class EventCommand
extends LeafCommand {
    private static final EventCommand INSTANCE = new EventCommand();

    private EventCommand() {
        super(RootCommand.getInstance(), "event", GenericArguments.seq((CommandElement[])new CommandElement[]{GenericArguments.string((Text)CommandKeys.EVENT_NAME), GenericArguments.firstParsing((CommandElement[])new CommandElement[]{GenericArguments.seq((CommandElement[])new CommandElement[]{GenericArguments.string((Text)CommandKeys.EVENT_EXECUTOR), GenericArguments.optional((CommandElement)GenericArguments.string((Text)CommandKeys.EVENT_COMMAND))}), GenericArguments.optional((CommandElement)GenericArguments.string((Text)CommandKeys.EVENT_COMMAND))})}));
    }

    @Override
    @Nonnull
    public CommandResult executeCommand(@Nonnull CommandSource src, @Nonnull CommandContext args) throws CommandException {
        CommandSource executor = src;
        if (args.hasAny(CommandKeys.EVENT_EXECUTOR)) {
            String eventExecutorName = (String)Util.getOrThrow(args, CommandKeys.EVENT_EXECUTOR);
            Optional player = Sponge.getServer().getPlayer(eventExecutorName);
            if (player.isPresent()) {
                executor = (CommandSource)player.get();
            }
        }
        if (args.hasAny(CommandKeys.EVENT_COMMAND)) {
            String eventCommand = (String)Util.getOrThrow(args, CommandKeys.EVENT_COMMAND);
            Sponge.getCommandManager().process(executor, eventCommand);
        }
        src.sendMessage((Text)Text.of((String)"This command is used with command blocks."));
        return CommandResult.success();
    }

    static EventCommand getInstance() {
        return INSTANCE;
    }
}

