/*
 * Decompiled with CFR 0.152.
 */
package io.github.m0pt0pmatt.survivalgames.command.executor;

import io.github.m0pt0pmatt.survivalgames.Util;
import io.github.m0pt0pmatt.survivalgames.command.CommandKeys;
import io.github.m0pt0pmatt.survivalgames.command.element.SurvivalGameCommandElement;
import io.github.m0pt0pmatt.survivalgames.command.executor.LeafCommand;
import io.github.m0pt0pmatt.survivalgames.command.executor.RootCommand;
import io.github.m0pt0pmatt.survivalgames.command.executor.SurvivalGamesCommand;
import io.github.m0pt0pmatt.survivalgames.game.SurvivalGame;
import io.github.m0pt0pmatt.survivalgames.game.SurvivalGameState;
import javax.annotation.Nonnull;
import org.spongepowered.api.command.CommandException;
import org.spongepowered.api.command.CommandResult;
import org.spongepowered.api.command.CommandSource;
import org.spongepowered.api.command.args.CommandContext;
import org.spongepowered.api.command.args.CommandElement;
import org.spongepowered.api.entity.living.player.Player;
import org.spongepowered.api.text.Text;

public class LeaveCommand
extends LeafCommand {
    private static final SurvivalGamesCommand INSTANCE = new LeaveCommand();

    private LeaveCommand() {
        super(RootCommand.getInstance(), "leave", (CommandElement)SurvivalGameCommandElement.getInstance());
    }

    @Override
    @Nonnull
    public CommandResult executeCommand(@Nonnull CommandSource src, @Nonnull CommandContext args) throws CommandException {
        SurvivalGame survivalGame = (SurvivalGame)Util.getOrThrow(args, CommandKeys.SURVIVAL_GAME);
        if (!(src instanceof Player)) {
            throw new CommandException((Text)Text.of((String)"Must be a player to execute this command"));
        }
        Player player = (Player)src;
        if (survivalGame.getState() != SurvivalGameState.READY) {
            throw new CommandException((Text)Text.of((String)("State must be " + (Object)((Object)SurvivalGameState.READY))));
        }
        survivalGame.removePlayer(player.getUniqueId());
        survivalGame.removeSpectator(player.getUniqueId());
        Util.sendSuccess(src, "Left game", survivalGame.getName());
        return CommandResult.success();
    }

    static SurvivalGamesCommand getInstance() {
        return INSTANCE;
    }
}

