/*
 * Decompiled with CFR 0.152.
 */
package io.github.m0pt0pmatt.survivalgames.command.executor;

import io.github.m0pt0pmatt.survivalgames.SurvivalGamesPlugin;
import io.github.m0pt0pmatt.survivalgames.Util;
import io.github.m0pt0pmatt.survivalgames.command.CommandKeys;
import io.github.m0pt0pmatt.survivalgames.command.element.ConfigFileCommandElement;
import io.github.m0pt0pmatt.survivalgames.command.element.SurvivalGameCommandElement;
import io.github.m0pt0pmatt.survivalgames.command.executor.LeafCommand;
import io.github.m0pt0pmatt.survivalgames.command.executor.RootCommand;
import io.github.m0pt0pmatt.survivalgames.command.executor.SurvivalGamesCommand;
import io.github.m0pt0pmatt.survivalgames.data.GameConfig;
import io.github.m0pt0pmatt.survivalgames.game.SurvivalGame;
import io.github.m0pt0pmatt.survivalgames.thread.DotProgressable;
import io.github.m0pt0pmatt.survivalgames.thread.ProgressBuilder;
import java.io.IOException;
import java.nio.file.Path;
import java.util.concurrent.Executor;
import javax.annotation.Nonnull;
import ninja.leaping.configurate.ConfigurationNode;
import ninja.leaping.configurate.ConfigurationOptions;
import ninja.leaping.configurate.commented.CommentedConfigurationNode;
import ninja.leaping.configurate.hocon.HoconConfigurationLoader;
import ninja.leaping.configurate.objectmapping.ObjectMapper;
import ninja.leaping.configurate.objectmapping.ObjectMappingException;
import org.spongepowered.api.command.CommandException;
import org.spongepowered.api.command.CommandResult;
import org.spongepowered.api.command.CommandSource;
import org.spongepowered.api.command.args.CommandContext;
import org.spongepowered.api.command.args.CommandElement;
import org.spongepowered.api.command.args.GenericArguments;
import org.spongepowered.api.text.Text;

public class SaveConfigCommand
extends LeafCommand {
    private static SurvivalGamesCommand INSTANCE = new SaveConfigCommand();

    private SaveConfigCommand() {
        super(RootCommand.getInstance(), "save", GenericArguments.seq((CommandElement[])new CommandElement[]{SurvivalGameCommandElement.getInstance(), GenericArguments.firstParsing((CommandElement[])new CommandElement[]{ConfigFileCommandElement.getInstance(), GenericArguments.string((Text)CommandKeys.FILE_NAME)})}));
    }

    @Override
    @Nonnull
    public CommandResult executeCommand(@Nonnull CommandSource src, @Nonnull CommandContext args) throws CommandException {
        ProgressBuilder.builder(src, (Executor)SurvivalGamesPlugin.SYNC_EXECUTOR, (Executor)SurvivalGamesPlugin.ASYNC_EXECUTOR).runAsync(new DotProgressable(() -> {
            try {
                Path potentialFile;
                if (args.hasAny(CommandKeys.FILE_PATH)) {
                    potentialFile = (Path)Util.getOrThrow(args, CommandKeys.FILE_PATH);
                } else if (args.hasAny(CommandKeys.FILE_NAME)) {
                    String potentialFileName = (String)Util.getOrThrow(args, CommandKeys.FILE_NAME);
                    potentialFile = SurvivalGamesPlugin.CONFIG_DIRECTORY.resolve(potentialFileName);
                } else {
                    throw new CommandException((Text)Text.of((String)"No file name"));
                }
                SurvivalGame survivalGame = (SurvivalGame)Util.getOrThrow(args, CommandKeys.SURVIVAL_GAME);
                HoconConfigurationLoader loader = ((HoconConfigurationLoader.Builder)HoconConfigurationLoader.builder().setPath(potentialFile)).build();
                try {
                    CommentedConfigurationNode node = (CommentedConfigurationNode)loader.load(ConfigurationOptions.defaults());
                    ObjectMapper.BoundInstance i = GameConfig.OBJECT_MAPPER.bind((Object)survivalGame.getConfig());
                    i.serialize((ConfigurationNode)node);
                    loader.save((ConfigurationNode)node);
                }
                catch (IOException | RuntimeException | ObjectMappingException e) {
                    e.printStackTrace();
                    throw new CommandException((Text)Text.of((String)"Error saving to file"), e);
                }
                Util.sendSuccess(src, "Survival Game Saved", potentialFile.getFileName());
            }
            catch (CommandException e) {
                throw new RuntimeException(e);
            }
        }), "Saving", null).start();
        return CommandResult.success();
    }

    public static SurvivalGamesCommand getInstance() {
        return INSTANCE;
    }
}

