/*
 * Decompiled with CFR 0.152.
 */
package io.github.m0pt0pmatt.survivalgames.command.executor;

import io.github.m0pt0pmatt.survivalgames.Util;
import io.github.m0pt0pmatt.survivalgames.command.CommandKeys;
import io.github.m0pt0pmatt.survivalgames.command.element.ConfigFileCommandElement;
import io.github.m0pt0pmatt.survivalgames.command.element.SurvivalGameCommandElement;
import io.github.m0pt0pmatt.survivalgames.command.executor.LeafCommand;
import io.github.m0pt0pmatt.survivalgames.command.executor.RootCommand;
import io.github.m0pt0pmatt.survivalgames.data.Schedule;
import io.github.m0pt0pmatt.survivalgames.game.SurvivalGame;
import io.github.m0pt0pmatt.survivalgames.schedule.ScheduleRepository;
import java.io.IOException;
import java.nio.file.Path;
import javax.annotation.Nonnull;
import ninja.leaping.configurate.ConfigurationNode;
import ninja.leaping.configurate.ConfigurationOptions;
import ninja.leaping.configurate.commented.CommentedConfigurationNode;
import ninja.leaping.configurate.hocon.HoconConfigurationLoader;
import ninja.leaping.configurate.objectmapping.ObjectMapper;
import ninja.leaping.configurate.objectmapping.ObjectMappingException;
import org.spongepowered.api.command.CommandException;
import org.spongepowered.api.command.CommandResult;
import org.spongepowered.api.command.CommandSource;
import org.spongepowered.api.command.args.CommandContext;
import org.spongepowered.api.command.args.CommandElement;
import org.spongepowered.api.command.args.GenericArguments;
import org.spongepowered.api.text.Text;

public class ScheduleCommand
extends LeafCommand {
    private static final ScheduleCommand INSTANCE = new ScheduleCommand();

    private ScheduleCommand() {
        super(RootCommand.getInstance(), "schedule", GenericArguments.seq((CommandElement[])new CommandElement[]{SurvivalGameCommandElement.getInstance(), ConfigFileCommandElement.getInstance()}));
    }

    @Override
    @Nonnull
    public CommandResult executeCommand(@Nonnull CommandSource src, @Nonnull CommandContext args) throws CommandException {
        SurvivalGame survivalGame = (SurvivalGame)Util.getOrThrow(args, CommandKeys.SURVIVAL_GAME);
        Path potentialFile = (Path)Util.getOrThrow(args, CommandKeys.FILE_PATH);
        HoconConfigurationLoader loader = ((HoconConfigurationLoader.Builder)HoconConfigurationLoader.builder().setPath(potentialFile)).build();
        try {
            CommentedConfigurationNode node = (CommentedConfigurationNode)loader.load(ConfigurationOptions.defaults());
            ObjectMapper.BoundInstance i = Schedule.OBJECT_MAPPER.bindToNew();
            Schedule schedule = (Schedule)i.populate((ConfigurationNode)node);
            ScheduleRepository.schedule(survivalGame, schedule);
        }
        catch (IOException | RuntimeException | ObjectMappingException e) {
            e.printStackTrace();
            throw new CommandException((Text)Text.of((String)"An error occurred when loading schedule"));
        }
        Util.sendSuccess(src, Text.of((Object[])new Object[]{"Scheduled ", survivalGame.getName()}));
        return CommandResult.success();
    }

    public static ScheduleCommand getInstance() {
        return INSTANCE;
    }
}

