/*
 * Decompiled with CFR 0.152.
 */
package io.github.m0pt0pmatt.survivalgames.command.executor;

import io.github.m0pt0pmatt.survivalgames.Util;
import io.github.m0pt0pmatt.survivalgames.command.CommandKeys;
import io.github.m0pt0pmatt.survivalgames.command.executor.LeafCommand;
import io.github.m0pt0pmatt.survivalgames.command.executor.RootCommand;
import java.lang.reflect.InvocationTargetException;
import javax.annotation.Nonnull;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.command.CommandException;
import org.spongepowered.api.command.CommandResult;
import org.spongepowered.api.command.CommandSource;
import org.spongepowered.api.command.args.CommandContext;
import org.spongepowered.api.command.args.GenericArguments;
import org.spongepowered.api.entity.living.player.Player;
import org.spongepowered.api.text.Text;
import org.spongepowered.api.world.World;

class TeleportCommand
extends LeafCommand {
    private static final TeleportCommand INSTANCE = new TeleportCommand();

    private TeleportCommand() {
        super(RootCommand.getInstance(), "teleport", GenericArguments.world((Text)CommandKeys.WORLD));
    }

    @Override
    @Nonnull
    public CommandResult executeCommand(@Nonnull CommandSource src, @Nonnull CommandContext args) throws CommandException {
        String worldName;
        Object worldInfo = Util.getOrThrow(args, CommandKeys.WORLD);
        try {
            worldName = (String)worldInfo.getClass().getMethod("getWorldName", new Class[0]).invoke(worldInfo, new Object[0]);
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            throw new CommandException((Text)Text.of((String)("Error: " + e.getMessage())), (Throwable)e);
        }
        if (src instanceof Player) {
            World world = (World)Util.getOrThrow(Sponge.getServer().getWorld(worldName), (Object)CommandKeys.WORLD);
            ((Player)src).setLocation(world.getSpawnLocation());
        }
        return CommandResult.success();
    }

    static TeleportCommand getInstance() {
        return INSTANCE;
    }
}

