/*
 * Decompiled with CFR 0.152.
 */
package io.github.m0pt0pmatt.survivalgames.command.executor;

import io.github.m0pt0pmatt.survivalgames.Util;
import io.github.m0pt0pmatt.survivalgames.command.CommandKeys;
import io.github.m0pt0pmatt.survivalgames.command.element.SurvivalGameCommandElement;
import io.github.m0pt0pmatt.survivalgames.command.executor.LeafCommand;
import io.github.m0pt0pmatt.survivalgames.command.executor.RootCommand;
import io.github.m0pt0pmatt.survivalgames.command.executor.SurvivalGamesCommand;
import io.github.m0pt0pmatt.survivalgames.game.SurvivalGame;
import io.github.m0pt0pmatt.survivalgames.schedule.ScheduleRepository;
import javax.annotation.Nonnull;
import org.spongepowered.api.command.CommandException;
import org.spongepowered.api.command.CommandResult;
import org.spongepowered.api.command.CommandSource;
import org.spongepowered.api.command.args.CommandContext;
import org.spongepowered.api.command.args.CommandElement;
import org.spongepowered.api.text.Text;

public class UnscheduleCommand
extends LeafCommand {
    private static final UnscheduleCommand INSTANCE = new UnscheduleCommand(RootCommand.getInstance(), "unschedule", (CommandElement)SurvivalGameCommandElement.getInstance());

    private UnscheduleCommand(SurvivalGamesCommand parent, String name, CommandElement arguments) {
        super(parent, name, arguments);
    }

    @Override
    @Nonnull
    public CommandResult executeCommand(@Nonnull CommandSource src, @Nonnull CommandContext args) throws CommandException {
        SurvivalGame survivalGame = (SurvivalGame)Util.getOrThrow(args, CommandKeys.SURVIVAL_GAME);
        ScheduleRepository.unschedule(survivalGame);
        Util.sendSuccess(src, Text.of((Object[])new Object[]{"Unscheduled ", survivalGame.getName()}));
        return CommandResult.success();
    }

    public static UnscheduleCommand getInstance() {
        return INSTANCE;
    }
}

