/*
 * Decompiled with CFR 0.152.
 */
package io.github.m0pt0pmatt.survivalgames.command.executor.add;

import io.github.m0pt0pmatt.survivalgames.Util;
import io.github.m0pt0pmatt.survivalgames.command.CommandKeys;
import io.github.m0pt0pmatt.survivalgames.command.element.SurvivalGameCommandElement;
import io.github.m0pt0pmatt.survivalgames.command.executor.LeafCommand;
import io.github.m0pt0pmatt.survivalgames.command.executor.SurvivalGamesCommand;
import io.github.m0pt0pmatt.survivalgames.command.executor.add.AddCommand;
import io.github.m0pt0pmatt.survivalgames.game.SurvivalGame;
import io.github.m0pt0pmatt.survivalgames.game.SurvivalGameState;
import javax.annotation.Nonnull;
import org.spongepowered.api.command.CommandException;
import org.spongepowered.api.command.CommandResult;
import org.spongepowered.api.command.CommandSource;
import org.spongepowered.api.command.args.CommandContext;
import org.spongepowered.api.command.args.CommandElement;
import org.spongepowered.api.command.args.GenericArguments;
import org.spongepowered.api.text.Text;

class AddEventIntervalCommand
extends LeafCommand {
    private static SurvivalGamesCommand INSTANCE = new AddEventIntervalCommand();

    private AddEventIntervalCommand() {
        super(AddCommand.getInstance(), "event-interval", GenericArguments.seq((CommandElement[])new CommandElement[]{SurvivalGameCommandElement.getInstance(), GenericArguments.string((Text)CommandKeys.INTERVAL_NAME), GenericArguments.integer((Text)CommandKeys.SECONDS_PER_INTERVAL)}));
    }

    @Override
    @Nonnull
    public CommandResult executeCommand(@Nonnull CommandSource src, @Nonnull CommandContext args) throws CommandException {
        SurvivalGame survivalGame = (SurvivalGame)Util.getOrThrow(args, CommandKeys.SURVIVAL_GAME);
        String intervalName = (String)Util.getOrThrow(args, CommandKeys.INTERVAL_NAME);
        Integer secondsPerInterval = (Integer)Util.getOrThrow(args, CommandKeys.SECONDS_PER_INTERVAL);
        if (survivalGame.getState() != SurvivalGameState.STOPPED) {
            throw new CommandException((Text)Text.of((String)("State must be " + (Object)((Object)SurvivalGameState.STOPPED))));
        }
        survivalGame.getConfig().getEventIntervals().put(intervalName, secondsPerInterval);
        Util.sendSuccess(src, "Event interval added", Text.of((Object[])new Object[]{intervalName, " -> ", secondsPerInterval}));
        return CommandResult.success();
    }

    static SurvivalGamesCommand getInstance() {
        return INSTANCE;
    }
}

