/*
 * Decompiled with CFR 0.152.
 */
package io.github.m0pt0pmatt.survivalgames.command.executor.add;

import io.github.m0pt0pmatt.survivalgames.Util;
import io.github.m0pt0pmatt.survivalgames.command.CommandKeys;
import io.github.m0pt0pmatt.survivalgames.command.element.SurvivalGameCommandElement;
import io.github.m0pt0pmatt.survivalgames.command.executor.LeafCommand;
import io.github.m0pt0pmatt.survivalgames.command.executor.SurvivalGamesCommand;
import io.github.m0pt0pmatt.survivalgames.command.executor.add.AddCommand;
import io.github.m0pt0pmatt.survivalgames.game.SurvivalGame;
import javax.annotation.Nonnull;
import org.spongepowered.api.command.CommandException;
import org.spongepowered.api.command.CommandResult;
import org.spongepowered.api.command.CommandSource;
import org.spongepowered.api.command.args.CommandContext;
import org.spongepowered.api.command.args.CommandElement;
import org.spongepowered.api.command.args.GenericArguments;
import org.spongepowered.api.data.type.HandTypes;
import org.spongepowered.api.entity.living.player.Player;
import org.spongepowered.api.item.inventory.ItemStack;
import org.spongepowered.api.text.Text;

class AddItemInHandCommand
extends LeafCommand {
    private static SurvivalGamesCommand INSTANCE = new AddItemInHandCommand();

    private AddItemInHandCommand() {
        super(AddCommand.getInstance(), "item-in-hand", GenericArguments.seq((CommandElement[])new CommandElement[]{SurvivalGameCommandElement.getInstance()}));
    }

    @Override
    @Nonnull
    public CommandResult executeCommand(@Nonnull CommandSource src, @Nonnull CommandContext args) throws CommandException {
        SurvivalGame survivalGame = (SurvivalGame)Util.getOrThrow(args, CommandKeys.SURVIVAL_GAME);
        if (!(src instanceof Player)) {
            throw new CommandException((Text)Text.of((String)"Only players can execute this command"));
        }
        Player player = (Player)src;
        ItemStack itemStack = (ItemStack)Util.getOrThrow(player.getItemInHand(HandTypes.MAIN_HAND), "item");
        survivalGame.getConfig().getItemConfig().getItems().add(itemStack.createSnapshot());
        Util.sendSuccess(src, "Item added", itemStack.getType().getName());
        return CommandResult.success();
    }

    static SurvivalGamesCommand getInstance() {
        return INSTANCE;
    }
}

