/*
 * Decompiled with CFR 0.152.
 */
package io.github.m0pt0pmatt.survivalgames.command.executor.add;

import com.flowpowered.math.vector.Vector3d;
import io.github.m0pt0pmatt.survivalgames.Util;
import io.github.m0pt0pmatt.survivalgames.command.CommandKeys;
import io.github.m0pt0pmatt.survivalgames.command.element.SurvivalGameCommandElement;
import io.github.m0pt0pmatt.survivalgames.command.executor.LeafCommand;
import io.github.m0pt0pmatt.survivalgames.command.executor.SurvivalGamesCommand;
import io.github.m0pt0pmatt.survivalgames.command.executor.add.AddCommand;
import io.github.m0pt0pmatt.survivalgames.data.MobSpawnArea;
import io.github.m0pt0pmatt.survivalgames.game.SurvivalGame;
import javax.annotation.Nonnull;
import org.spongepowered.api.command.CommandException;
import org.spongepowered.api.command.CommandResult;
import org.spongepowered.api.command.CommandSource;
import org.spongepowered.api.command.args.CommandContext;
import org.spongepowered.api.command.args.CommandElement;
import org.spongepowered.api.command.args.GenericArguments;
import org.spongepowered.api.entity.EntityType;
import org.spongepowered.api.text.Text;

class AddMobSpawnAreaCommand
extends LeafCommand {
    private static SurvivalGamesCommand INSTANCE = new AddMobSpawnAreaCommand();

    private AddMobSpawnAreaCommand() {
        super(AddCommand.getInstance(), "mob-spawn-area", GenericArguments.seq((CommandElement[])new CommandElement[]{SurvivalGameCommandElement.getInstance(), GenericArguments.vector3d((Text)CommandKeys.VECTOR1), GenericArguments.vector3d((Text)CommandKeys.VECTOR2), GenericArguments.catalogedElement((Text)CommandKeys.ENTITY_TYPE, EntityType.class), GenericArguments.integer((Text)CommandKeys.SPAWN_RATE_PER_MINUTE)}));
    }

    @Override
    @Nonnull
    public CommandResult executeCommand(@Nonnull CommandSource src, @Nonnull CommandContext args) throws CommandException {
        SurvivalGame survivalGame = (SurvivalGame)Util.getOrThrow(args, CommandKeys.SURVIVAL_GAME);
        Vector3d vector1 = (Vector3d)Util.getOrThrow(args, CommandKeys.VECTOR1);
        Vector3d vector2 = (Vector3d)Util.getOrThrow(args, CommandKeys.VECTOR2);
        EntityType entityType = (EntityType)Util.getOrThrow(args, CommandKeys.ENTITY_TYPE);
        Integer spawnRatePerMinute = (Integer)Util.getOrThrow(args, CommandKeys.SPAWN_RATE_PER_MINUTE);
        MobSpawnArea mobSpawnArea = new MobSpawnArea();
        mobSpawnArea.addBoundaryVector(vector1);
        mobSpawnArea.addBoundaryVector(vector2);
        mobSpawnArea.setEntityType(entityType);
        mobSpawnArea.setSpawnRatePerMinute(spawnRatePerMinute);
        survivalGame.getConfig().getMobSpawnAreas().add(mobSpawnArea);
        Util.sendSuccess(src, "Added mob-spawn-area");
        return CommandResult.success();
    }

    static SurvivalGamesCommand getInstance() {
        return INSTANCE;
    }
}

