/*
 * Decompiled with CFR 0.152.
 */
package io.github.m0pt0pmatt.survivalgames.command.executor.add;

import com.flowpowered.math.vector.Vector3d;
import io.github.m0pt0pmatt.survivalgames.command.executor.BlockRayCommand;
import io.github.m0pt0pmatt.survivalgames.command.executor.SurvivalGamesCommand;
import io.github.m0pt0pmatt.survivalgames.command.executor.add.AddCommand;
import org.spongepowered.api.command.CommandException;
import org.spongepowered.api.command.CommandSource;
import org.spongepowered.api.text.Text;
import org.spongepowered.api.world.Location;
import org.spongepowered.api.world.World;

class AddSpawnPointCommand
extends BlockRayCommand {
    private static final SurvivalGamesCommand INSTANCE = new AddSpawnPointCommand();

    private AddSpawnPointCommand() {
        super(AddCommand.getInstance(), "spawn", (survivalGame, location) -> {
            Vector3d vector = location.getBlockPosition().toDouble();
            if (!survivalGame.getConfig().getSpawnPoints().contains(vector)) {
                survivalGame.getConfig().getSpawnPoints().add(vector);
            }
        }, (Text)Text.of((String)"Spawn point added."));
    }

    @Override
    protected Location<World> getLocation(CommandSource commandSource) throws CommandException {
        return super.getLocation(commandSource).add(0.0, 1.0, 0.0);
    }

    static SurvivalGamesCommand getInstance() {
        return INSTANCE;
    }
}

