/*
 * Decompiled with CFR 0.152.
 */
package io.github.m0pt0pmatt.survivalgames.command.executor.print;

import com.google.common.base.Preconditions;
import io.github.m0pt0pmatt.survivalgames.Util;
import io.github.m0pt0pmatt.survivalgames.command.CommandKeys;
import io.github.m0pt0pmatt.survivalgames.command.executor.LeafCommand;
import io.github.m0pt0pmatt.survivalgames.command.executor.print.PrintCommand;
import io.github.m0pt0pmatt.survivalgames.game.SurvivalGame;
import java.util.Optional;
import java.util.function.Function;
import javax.annotation.Nonnull;
import org.spongepowered.api.command.CommandException;
import org.spongepowered.api.command.CommandResult;
import org.spongepowered.api.command.CommandSource;
import org.spongepowered.api.command.args.CommandContext;
import org.spongepowered.api.command.args.CommandElement;
import org.spongepowered.api.text.Text;

class AbstractPrintCommand
extends LeafCommand {
    private final Function<SurvivalGame, Optional<Text>> function;

    AbstractPrintCommand(String name, CommandElement arguments, Function<SurvivalGame, Optional<Text>> function) {
        super(PrintCommand.getInstance(), name, arguments);
        this.function = (Function)Preconditions.checkNotNull(function, (Object)"function");
    }

    @Override
    @Nonnull
    public CommandResult executeCommand(@Nonnull CommandSource src, @Nonnull CommandContext args) throws CommandException {
        SurvivalGame survivalGame = (SurvivalGame)Util.getOrThrow(args, CommandKeys.SURVIVAL_GAME);
        Text value = Util.getOrThrow(this.function.apply(survivalGame), this.getAliases().get(0));
        Util.sendSuccess(src, this.getAliases().get(0), value);
        return CommandResult.success();
    }
}

