/*
 * Decompiled with CFR 0.152.
 */
package io.github.m0pt0pmatt.survivalgames.command.executor.remove;

import io.github.m0pt0pmatt.survivalgames.Util;
import io.github.m0pt0pmatt.survivalgames.command.CommandKeys;
import io.github.m0pt0pmatt.survivalgames.command.element.EventIntervalCommandElement;
import io.github.m0pt0pmatt.survivalgames.command.element.SurvivalGameCommandElement;
import io.github.m0pt0pmatt.survivalgames.command.executor.LeafCommand;
import io.github.m0pt0pmatt.survivalgames.command.executor.SurvivalGamesCommand;
import io.github.m0pt0pmatt.survivalgames.command.executor.remove.RemoveCommand;
import io.github.m0pt0pmatt.survivalgames.game.SurvivalGame;
import io.github.m0pt0pmatt.survivalgames.game.SurvivalGameState;
import javax.annotation.Nonnull;
import org.spongepowered.api.command.CommandException;
import org.spongepowered.api.command.CommandResult;
import org.spongepowered.api.command.CommandSource;
import org.spongepowered.api.command.args.CommandContext;
import org.spongepowered.api.command.args.CommandElement;
import org.spongepowered.api.command.args.GenericArguments;
import org.spongepowered.api.text.Text;

class RemoveEventIntervalsCommand
extends LeafCommand {
    private static SurvivalGamesCommand INSTANCE = new RemoveEventIntervalsCommand();

    private RemoveEventIntervalsCommand() {
        super(RemoveCommand.getInstance(), "event-interval", GenericArguments.seq((CommandElement[])new CommandElement[]{SurvivalGameCommandElement.getInstance(), EventIntervalCommandElement.getInstance()}));
    }

    @Override
    @Nonnull
    public CommandResult executeCommand(@Nonnull CommandSource src, @Nonnull CommandContext args) throws CommandException {
        SurvivalGame survivalGame = (SurvivalGame)Util.getOrThrow(args, CommandKeys.SURVIVAL_GAME);
        String intervalName = (String)Util.getOrThrow(args, CommandKeys.INTERVAL_NAME);
        if (survivalGame.getState() != SurvivalGameState.STOPPED) {
            throw new CommandException((Text)Text.of((String)("State must be " + (Object)((Object)SurvivalGameState.STOPPED))));
        }
        survivalGame.getConfig().getEventIntervals().remove(intervalName);
        src.sendMessage(Text.of((Object[])new Object[]{"Removed event interval", intervalName}));
        return CommandResult.success();
    }

    static SurvivalGamesCommand getInstance() {
        return INSTANCE;
    }
}

