/*
 * Decompiled with CFR 0.152.
 */
package io.github.m0pt0pmatt.survivalgames.command.executor.remove;

import io.github.m0pt0pmatt.survivalgames.Util;
import io.github.m0pt0pmatt.survivalgames.command.CommandKeys;
import io.github.m0pt0pmatt.survivalgames.command.element.MobSpawnAreaCommandElement;
import io.github.m0pt0pmatt.survivalgames.command.element.SurvivalGameCommandElement;
import io.github.m0pt0pmatt.survivalgames.command.executor.LeafCommand;
import io.github.m0pt0pmatt.survivalgames.command.executor.SurvivalGamesCommand;
import io.github.m0pt0pmatt.survivalgames.command.executor.remove.RemoveCommand;
import io.github.m0pt0pmatt.survivalgames.data.MobSpawnArea;
import io.github.m0pt0pmatt.survivalgames.game.SurvivalGame;
import io.github.m0pt0pmatt.survivalgames.game.SurvivalGameState;
import javax.annotation.Nonnull;
import org.spongepowered.api.command.CommandException;
import org.spongepowered.api.command.CommandResult;
import org.spongepowered.api.command.CommandSource;
import org.spongepowered.api.command.args.CommandContext;
import org.spongepowered.api.command.args.CommandElement;
import org.spongepowered.api.command.args.GenericArguments;
import org.spongepowered.api.text.Text;

class RemoveMobSpawnAreaCommand
extends LeafCommand {
    private static SurvivalGamesCommand INSTANCE = new RemoveMobSpawnAreaCommand();

    private RemoveMobSpawnAreaCommand() {
        super(RemoveCommand.getInstance(), "mob-spawn-area", GenericArguments.seq((CommandElement[])new CommandElement[]{SurvivalGameCommandElement.getInstance(), MobSpawnAreaCommandElement.getInstance()}));
    }

    @Override
    @Nonnull
    public CommandResult executeCommand(@Nonnull CommandSource src, @Nonnull CommandContext args) throws CommandException {
        SurvivalGame survivalGame = (SurvivalGame)Util.getOrThrow(args, CommandKeys.SURVIVAL_GAME);
        MobSpawnArea mobSpawnArea = (MobSpawnArea)Util.getOrThrow(args, CommandKeys.MOB_SPAWN_AREA);
        if (survivalGame.getState() != SurvivalGameState.STOPPED) {
            throw new CommandException((Text)Text.of((String)("State must be " + (Object)((Object)SurvivalGameState.STOPPED))));
        }
        survivalGame.getActiveMobSpawners().remove(mobSpawnArea.getId());
        Util.sendSuccess(src, "Removed Mob Spawn Area", mobSpawnArea.getId());
        return CommandResult.success();
    }

    static SurvivalGamesCommand getInstance() {
        return INSTANCE;
    }
}

