/*
 * Decompiled with CFR 0.152.
 */
package io.github.m0pt0pmatt.survivalgames.command.executor.remove;

import com.flowpowered.math.vector.Vector3d;
import io.github.m0pt0pmatt.survivalgames.command.executor.BlockRayCommand;
import io.github.m0pt0pmatt.survivalgames.command.executor.SurvivalGamesCommand;
import io.github.m0pt0pmatt.survivalgames.command.executor.remove.RemoveCommand;
import java.util.Iterator;
import org.spongepowered.api.command.CommandException;
import org.spongepowered.api.command.CommandSource;
import org.spongepowered.api.text.Text;
import org.spongepowered.api.world.Location;
import org.spongepowered.api.world.World;

class RemoveSpawnPointCommand
extends BlockRayCommand {
    private static final SurvivalGamesCommand INSTANCE = new RemoveSpawnPointCommand();

    private RemoveSpawnPointCommand() {
        super(RemoveCommand.getInstance(), "spawn", (survivalGame, location) -> {
            Iterator<Vector3d> i = survivalGame.getConfig().getSpawnPoints().iterator();
            while (i.hasNext()) {
                Vector3d v = i.next();
                if (!v.toInt().equals((Object)location.getBlockPosition())) continue;
                i.remove();
                break;
            }
        }, (Text)Text.of((String)"Removed spawn point"));
    }

    @Override
    protected Location<World> getLocation(CommandSource commandSource) throws CommandException {
        return super.getLocation(commandSource).add(0.0, 1.0, 0.0);
    }

    static SurvivalGamesCommand getInstance() {
        return INSTANCE;
    }
}

