/*
 * Decompiled with CFR 0.152.
 */
package io.github.m0pt0pmatt.survivalgames.command.executor.set;

import io.github.m0pt0pmatt.survivalgames.SurvivalGamesPlugin;
import io.github.m0pt0pmatt.survivalgames.Util;
import io.github.m0pt0pmatt.survivalgames.command.CommandKeys;
import io.github.m0pt0pmatt.survivalgames.command.element.SurvivalGameCommandElement;
import io.github.m0pt0pmatt.survivalgames.command.executor.LeafCommand;
import io.github.m0pt0pmatt.survivalgames.command.executor.SurvivalGamesCommand;
import io.github.m0pt0pmatt.survivalgames.command.executor.set.SetCommand;
import io.github.m0pt0pmatt.survivalgames.game.SurvivalGame;
import io.github.m0pt0pmatt.survivalgames.thread.BlankProgressable;
import io.github.m0pt0pmatt.survivalgames.thread.ProgressBuilder;
import io.github.m0pt0pmatt.survivalgames.thread.SetBlocksProgressable;
import java.time.Duration;
import java.time.temporal.ChronoUnit;
import java.time.temporal.TemporalAmount;
import java.util.concurrent.Executor;
import javax.annotation.Nonnull;
import org.spongepowered.api.command.CommandException;
import org.spongepowered.api.command.CommandResult;
import org.spongepowered.api.command.CommandSource;
import org.spongepowered.api.command.args.CommandContext;
import org.spongepowered.api.command.args.CommandElement;

public class SetBlocksCommand
extends LeafCommand {
    private static final SurvivalGamesCommand INSTANCE = new SetBlocksCommand();

    private SetBlocksCommand() {
        super(SetCommand.getInstance(), "blocks", (CommandElement)SurvivalGameCommandElement.getInstance());
    }

    @Override
    @Nonnull
    public CommandResult executeCommand(@Nonnull CommandSource src, @Nonnull CommandContext args) throws CommandException {
        SurvivalGame survivalGame = (SurvivalGame)Util.getOrThrow(args, CommandKeys.SURVIVAL_GAME);
        ProgressBuilder.builder(src, (Executor)SurvivalGamesPlugin.SYNC_EXECUTOR, (Executor)SurvivalGamesPlugin.ASYNC_EXECUTOR).runSync(new SetBlocksProgressable(survivalGame), "Setting Blocks", (TemporalAmount)Duration.of(600L, ChronoUnit.SECONDS)).runSync(new BlankProgressable(() -> Util.sendSuccess(src, "Set map blocks and command blocks")), "", (TemporalAmount)Duration.of(600L, ChronoUnit.SECONDS)).start();
        return CommandResult.success();
    }

    public static SurvivalGamesCommand getInstance() {
        return INSTANCE;
    }
}

