/*
 * Decompiled with CFR 0.152.
 */
package io.github.m0pt0pmatt.survivalgames.command.executor.set;

import io.github.m0pt0pmatt.survivalgames.Util;
import io.github.m0pt0pmatt.survivalgames.command.CommandKeys;
import io.github.m0pt0pmatt.survivalgames.command.element.SurvivalGameCommandElement;
import io.github.m0pt0pmatt.survivalgames.command.executor.LeafCommand;
import io.github.m0pt0pmatt.survivalgames.command.executor.SurvivalGamesCommand;
import io.github.m0pt0pmatt.survivalgames.command.executor.set.SetCommand;
import io.github.m0pt0pmatt.survivalgames.game.SurvivalGame;
import javax.annotation.Nonnull;
import org.spongepowered.api.command.CommandException;
import org.spongepowered.api.command.CommandResult;
import org.spongepowered.api.command.CommandSource;
import org.spongepowered.api.command.args.CommandContext;
import org.spongepowered.api.command.args.CommandElement;
import org.spongepowered.api.command.args.GenericArguments;
import org.spongepowered.api.text.Text;

class SetPlayerLimitCommand
extends LeafCommand {
    private static final SurvivalGamesCommand INSTANCE = new SetPlayerLimitCommand();

    private SetPlayerLimitCommand() {
        super(SetCommand.getInstance(), "player-limit", GenericArguments.seq((CommandElement[])new CommandElement[]{SurvivalGameCommandElement.getInstance(), GenericArguments.integer((Text)CommandKeys.PLAYER_LIMIT)}));
    }

    @Override
    @Nonnull
    public CommandResult executeCommand(@Nonnull CommandSource src, @Nonnull CommandContext args) throws CommandException {
        SurvivalGame survivalGame = (SurvivalGame)Util.getOrThrow(args, CommandKeys.SURVIVAL_GAME);
        Integer playerLimit = (Integer)Util.getOrThrow(args, CommandKeys.PLAYER_LIMIT);
        survivalGame.getConfig().setPlayerLimit(playerLimit);
        Util.sendSuccess(src, "Set player limit", playerLimit);
        return CommandResult.success();
    }

    static SurvivalGamesCommand getInstance() {
        return INSTANCE;
    }
}

