/*
 * Decompiled with CFR 0.152.
 */
package io.github.m0pt0pmatt.survivalgames.command.executor.set;

import io.github.m0pt0pmatt.survivalgames.Util;
import io.github.m0pt0pmatt.survivalgames.command.CommandKeys;
import io.github.m0pt0pmatt.survivalgames.command.element.SurvivalGameCommandElement;
import io.github.m0pt0pmatt.survivalgames.command.executor.LeafCommand;
import io.github.m0pt0pmatt.survivalgames.command.executor.SurvivalGamesCommand;
import io.github.m0pt0pmatt.survivalgames.command.executor.set.SetCommand;
import io.github.m0pt0pmatt.survivalgames.game.SurvivalGame;
import java.lang.reflect.InvocationTargetException;
import javax.annotation.Nonnull;
import org.spongepowered.api.command.CommandException;
import org.spongepowered.api.command.CommandResult;
import org.spongepowered.api.command.CommandSource;
import org.spongepowered.api.command.args.CommandContext;
import org.spongepowered.api.command.args.CommandElement;
import org.spongepowered.api.command.args.GenericArguments;
import org.spongepowered.api.text.Text;

class SetWorldNameCommand
extends LeafCommand {
    private static final SurvivalGamesCommand INSTANCE = new SetWorldNameCommand();

    private SetWorldNameCommand() {
        super(SetCommand.getInstance(), "world-name", GenericArguments.seq((CommandElement[])new CommandElement[]{SurvivalGameCommandElement.getInstance(), GenericArguments.world((Text)CommandKeys.WORLD_NAME)}));
    }

    @Override
    @Nonnull
    public CommandResult executeCommand(@Nonnull CommandSource src, @Nonnull CommandContext args) throws CommandException {
        String worldName;
        SurvivalGame survivalGame = (SurvivalGame)Util.getOrThrow(args, CommandKeys.SURVIVAL_GAME);
        Object worldInfo = Util.getOrThrow(args, CommandKeys.WORLD_NAME);
        try {
            worldName = (String)worldInfo.getClass().getMethod("getWorldName", new Class[0]).invoke(worldInfo, new Object[0]);
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            throw new CommandException((Text)Text.of((String)("Error: " + e.getMessage())), (Throwable)e);
        }
        survivalGame.getConfig().setWorldName(worldName);
        Util.sendSuccess(src, "Set world name", worldName);
        return CommandResult.success();
    }

    static SurvivalGamesCommand getInstance() {
        return INSTANCE;
    }
}

