/*
 * Decompiled with CFR 0.152.
 */
package io.github.m0pt0pmatt.survivalgames.command.executor.state;

import com.google.common.base.Preconditions;
import io.github.m0pt0pmatt.survivalgames.SurvivalGamesPlugin;
import io.github.m0pt0pmatt.survivalgames.Util;
import io.github.m0pt0pmatt.survivalgames.command.CommandKeys;
import io.github.m0pt0pmatt.survivalgames.command.element.SurvivalGameCommandElement;
import io.github.m0pt0pmatt.survivalgames.command.executor.LeafCommand;
import io.github.m0pt0pmatt.survivalgames.command.executor.SurvivalGamesCommand;
import io.github.m0pt0pmatt.survivalgames.game.SurvivalGame;
import io.github.m0pt0pmatt.survivalgames.game.SurvivalGameState;
import io.github.m0pt0pmatt.survivalgames.thread.BlankProgressable;
import io.github.m0pt0pmatt.survivalgames.thread.DotProgressable;
import io.github.m0pt0pmatt.survivalgames.thread.ProgressBuilder;
import java.time.Duration;
import java.time.temporal.ChronoUnit;
import java.time.temporal.TemporalAmount;
import java.util.Set;
import java.util.concurrent.Executor;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import org.spongepowered.api.command.CommandException;
import org.spongepowered.api.command.CommandResult;
import org.spongepowered.api.command.CommandSource;
import org.spongepowered.api.command.args.CommandContext;
import org.spongepowered.api.command.args.CommandElement;
import org.spongepowered.api.text.Text;
import org.spongepowered.api.text.format.TextColors;

class AbstractStateCommand
extends LeafCommand {
    private final Set<SurvivalGameState> states;
    private final SurvivalGameState targetState;
    private final Consumer<SurvivalGame> action;

    AbstractStateCommand(SurvivalGamesCommand parentCommand, String name, Set<SurvivalGameState> states, SurvivalGameState targetState, Consumer<SurvivalGame> action) {
        super(parentCommand, name, (CommandElement)SurvivalGameCommandElement.getInstance());
        this.states = (Set)Preconditions.checkNotNull(states, (Object)"states");
        this.targetState = (SurvivalGameState)((Object)Preconditions.checkNotNull((Object)((Object)targetState), (Object)"targetState"));
        this.action = (Consumer)Preconditions.checkNotNull(action, (Object)"action");
    }

    @Override
    @Nonnull
    public CommandResult executeCommand(@Nonnull CommandSource src, @Nonnull CommandContext args) throws CommandException {
        SurvivalGame survivalGame = (SurvivalGame)Util.getOrThrow(args, CommandKeys.SURVIVAL_GAME);
        SurvivalGameState oldState = survivalGame.getState();
        if (!this.states.contains((Object)oldState)) {
            throw new CommandException(Text.of((String)"Must be in one of the following states: ").concat(Text.joinWith((Text)Text.of((char)':'), (Iterable)this.states.stream().map(xva$0 -> Text.of((Object[])new Object[]{xva$0})).collect(Collectors.toList()))));
        }
        Duration timeout = Duration.of(600L, ChronoUnit.SECONDS);
        ProgressBuilder.builder(src, (Executor)SurvivalGamesPlugin.SYNC_EXECUTOR, (Executor)SurvivalGamesPlugin.ASYNC_EXECUTOR).runSync(new DotProgressable(() -> {
            try {
                this.action.accept(survivalGame);
            }
            catch (RuntimeException e) {
                throw new RuntimeException("Error while switching states: " + e.getMessage(), e);
            }
        }), this.formatTargetState(survivalGame), (TemporalAmount)timeout).runSync(new BlankProgressable(() -> {
            if (survivalGame.getState() == this.targetState) {
                Util.sendSuccess(src, Text.of((Object[])new Object[]{"State changed from ", TextColors.BLUE, oldState, TextColors.BLUE, " to ", TextColors.BLUE, survivalGame.getState()}));
            } else {
                Util.sendError(src, "Error changing state from " + (Object)((Object)oldState) + " to ", (Object)survivalGame.getState());
            }
        }), "", (TemporalAmount)timeout).start();
        return CommandResult.success();
    }

    private String formatTargetState(SurvivalGame survivalGame) {
        return this.targetState.getAdjective().substring(0, 1).toUpperCase() + this.targetState.getAdjective().substring(1).toLowerCase() + " Game " + survivalGame.getName();
    }
}

