/*
 * Decompiled with CFR 0.152.
 */
package io.github.m0pt0pmatt.survivalgames.command.executor.state;

import io.github.m0pt0pmatt.survivalgames.Util;
import io.github.m0pt0pmatt.survivalgames.command.CommandKeys;
import io.github.m0pt0pmatt.survivalgames.command.element.SurvivalGameCommandElement;
import io.github.m0pt0pmatt.survivalgames.command.executor.LeafCommand;
import io.github.m0pt0pmatt.survivalgames.command.executor.RootCommand;
import io.github.m0pt0pmatt.survivalgames.command.executor.SurvivalGamesCommand;
import io.github.m0pt0pmatt.survivalgames.game.SurvivalGame;
import io.github.m0pt0pmatt.survivalgames.game.SurvivalGameState;
import io.github.m0pt0pmatt.survivalgames.game.SurvivalGameStateManager;
import javax.annotation.Nonnull;
import org.spongepowered.api.command.CommandException;
import org.spongepowered.api.command.CommandResult;
import org.spongepowered.api.command.CommandSource;
import org.spongepowered.api.command.args.CommandContext;
import org.spongepowered.api.command.args.CommandElement;
import org.spongepowered.api.text.Text;

public class DeathMatchSurvivalGameCommand
extends LeafCommand {
    private static final SurvivalGamesCommand INSTANCE = new DeathMatchSurvivalGameCommand();

    private DeathMatchSurvivalGameCommand() {
        super(RootCommand.getInstance(), "death-match", (CommandElement)SurvivalGameCommandElement.getInstance());
    }

    @Override
    @Nonnull
    public CommandResult executeCommand(@Nonnull CommandSource src, @Nonnull CommandContext args) throws CommandException {
        SurvivalGame survivalGame = (SurvivalGame)Util.getOrThrow(args, CommandKeys.SURVIVAL_GAME);
        if (survivalGame.getState() != SurvivalGameState.RUNNING) {
            throw new CommandException((Text)Text.of((String)("Must be in the " + (Object)((Object)SurvivalGameState.RUNNING) + " states.")));
        }
        SurvivalGameStateManager.deathMatch(survivalGame);
        Util.sendSuccess(src, "Started deathmatch", survivalGame.getName());
        return CommandResult.success();
    }

    public static SurvivalGamesCommand getInstance() {
        return INSTANCE;
    }
}

