/*
 * Decompiled with CFR 0.152.
 */
package io.github.m0pt0pmatt.survivalgames.command.executor.unset;

import com.google.common.base.Preconditions;
import io.github.m0pt0pmatt.survivalgames.Util;
import io.github.m0pt0pmatt.survivalgames.command.CommandKeys;
import io.github.m0pt0pmatt.survivalgames.command.element.SurvivalGameCommandElement;
import io.github.m0pt0pmatt.survivalgames.command.executor.LeafCommand;
import io.github.m0pt0pmatt.survivalgames.command.executor.unset.UnsetCommand;
import io.github.m0pt0pmatt.survivalgames.game.SurvivalGame;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import org.spongepowered.api.command.CommandException;
import org.spongepowered.api.command.CommandResult;
import org.spongepowered.api.command.CommandSource;
import org.spongepowered.api.command.args.CommandContext;
import org.spongepowered.api.command.args.CommandElement;
import org.spongepowered.api.text.Text;

class AbstractUnsetCommand
extends LeafCommand {
    private final Consumer<SurvivalGame> consumer;
    private final Text message;

    AbstractUnsetCommand(String name, Consumer<SurvivalGame> consumer, Text message) {
        super(UnsetCommand.getInstance(), name, (CommandElement)SurvivalGameCommandElement.getInstance());
        this.consumer = (Consumer)Preconditions.checkNotNull(consumer, (Object)"consumer");
        this.message = (Text)Preconditions.checkNotNull((Object)message, (Object)"message");
    }

    @Override
    @Nonnull
    public CommandResult executeCommand(@Nonnull CommandSource src, @Nonnull CommandContext args) throws CommandException {
        SurvivalGame survivalGame = (SurvivalGame)Util.getOrThrow(args, CommandKeys.SURVIVAL_GAME);
        try {
            this.consumer.accept(survivalGame);
        }
        catch (RuntimeException e) {
            throw new CommandException((Text)Text.of((String)("Error while unsetting: " + e.getMessage())), (Throwable)e);
        }
        Util.sendSuccess(src, this.message);
        return CommandResult.success();
    }
}

