/*
 * Decompiled with CFR 0.152.
 */
package io.github.m0pt0pmatt.survivalgames.data;

import com.flowpowered.math.vector.Vector3d;
import java.util.Optional;
import ninja.leaping.configurate.objectmapping.Setting;
import ninja.leaping.configurate.objectmapping.serialize.ConfigSerializable;

@ConfigSerializable
public class Area {
    @Setting(value="lesser-boundary", comment="Lesser Map boundary")
    private Vector3d lesserBoundary;
    @Setting(value="greater-boundary", comment="Greater Map boundary")
    private Vector3d greaterBoundary;

    public Optional<Vector3d> getLesserBoundary() {
        return Optional.ofNullable(this.lesserBoundary);
    }

    public Optional<Vector3d> getGreaterBoundary() {
        if (this.greaterBoundary != null) {
            return Optional.of(this.greaterBoundary);
        }
        return this.getLesserBoundary();
    }

    public void addBoundaryVector(Vector3d vector3i) {
        if (vector3i == null) {
            return;
        }
        if (this.lesserBoundary == null) {
            this.lesserBoundary = vector3i;
        } else if (this.greaterBoundary != null) {
            double x1 = this.lesserBoundary.getX();
            double x2 = this.greaterBoundary.getX();
            double x3 = vector3i.getX();
            double y1 = this.lesserBoundary.getY();
            double y2 = this.greaterBoundary.getY();
            double y3 = vector3i.getY();
            double z1 = this.lesserBoundary.getZ();
            double z2 = this.greaterBoundary.getZ();
            double z3 = vector3i.getZ();
            this.lesserBoundary = new Vector3d(Double.min(Double.min(x1, x2), x3), Double.min(Double.min(y1, y2), y3), Double.min(Double.min(z1, z2), z3));
            this.greaterBoundary = new Vector3d(Double.max(Double.max(x1, x2), x3), Double.max(Double.max(y1, y2), y3), Double.max(Double.max(z1, z2), z3));
        } else {
            double x1 = this.lesserBoundary.getX();
            double x2 = vector3i.getX();
            double y1 = this.lesserBoundary.getY();
            double y2 = vector3i.getY();
            double z1 = this.lesserBoundary.getZ();
            double z2 = vector3i.getZ();
            this.lesserBoundary = new Vector3d(Double.min(x1, x2), Double.min(y1, y2), Double.min(z1, z2));
            this.greaterBoundary = new Vector3d(Double.max(x1, x2), Double.max(y1, y2), Double.max(z1, z2));
        }
    }

    public void clearBoundaryVectors() {
        this.lesserBoundary = null;
        this.greaterBoundary = null;
    }
}

