/*
 * Decompiled with CFR 0.152.
 */
package io.github.m0pt0pmatt.survivalgames.data;

import com.flowpowered.math.vector.Vector3d;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import io.github.m0pt0pmatt.survivalgames.data.Area;
import io.github.m0pt0pmatt.survivalgames.data.ItemConfig;
import io.github.m0pt0pmatt.survivalgames.data.MobSpawnArea;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import ninja.leaping.configurate.objectmapping.ObjectMapper;
import ninja.leaping.configurate.objectmapping.ObjectMappingException;
import ninja.leaping.configurate.objectmapping.Setting;
import ninja.leaping.configurate.objectmapping.serialize.ConfigSerializable;
import org.spongepowered.api.block.BlockSnapshot;

@ConfigSerializable
public class GameConfig {
    private static final int DEFAULT_PLAYER_LIMIT = 4;
    private static final int DEFAULT_COUNTDOWN_SECONDS = 10;
    public static ObjectMapper<GameConfig> OBJECT_MAPPER;
    @Setting(value="spawn-points", comment="Where players spawn when the game starts.")
    private List<Vector3d> spawnPoints;
    @Setting(value="world-name", comment="The name of the world where the survival game will take place.")
    private String worldName;
    @Setting(value="exit-world-name", comment="The name of the world where players teleport to once they leave the game.")
    private String exitWorldName;
    @Setting(value="exit-vector", comment="The location where players teleport to once they leave the game.")
    private Vector3d exitVector;
    @Setting(value="center-vector", comment="The center of the survival game map.")
    private Vector3d centerVector;
    @Setting(value="player-limit", comment="The max number of players which can join the game.")
    private Integer playerLimit;
    @Setting(value="countdown-seconds", comment="The number of seconds to countdown once the survival game starts.")
    private Integer countdownSeconds;
    @Setting(value="chest-midpoint")
    private Integer chestMidpoint;
    @Setting(value="chest-range")
    private Integer chestRange;
    @Setting(value="itemConfig")
    private ItemConfig itemConfig;
    @Setting(value="blockArea")
    private Area blockArea;
    @Setting(value="mobSpawnAreas")
    private List<MobSpawnArea> mobSpawnAreas = Lists.newArrayList();
    @Setting(value="event-intervals")
    private Map<String, Integer> eventIntervals = Maps.newHashMap();
    private List<BlockSnapshot> blocks = Lists.newArrayList();

    public GameConfig() {
        this.setPlayerLimit(4);
        this.setCountdownSeconds(10);
        this.spawnPoints = new ArrayList<Vector3d>();
    }

    public Optional<String> getWorldName() {
        return Optional.ofNullable(this.worldName);
    }

    public void setWorldName(String worldName) {
        this.worldName = worldName;
    }

    public Optional<String> getExitWorldName() {
        return Optional.ofNullable(this.exitWorldName);
    }

    public void setExitWorldName(String exitWorldName) {
        this.exitWorldName = exitWorldName;
    }

    public Optional<Vector3d> getExitVector() {
        return Optional.ofNullable(this.exitVector);
    }

    public void setExitVector(Vector3d exitVector) {
        this.exitVector = exitVector;
    }

    public Optional<Vector3d> getCenterVector() {
        return Optional.ofNullable(this.centerVector);
    }

    public void setCenterVector(Vector3d centerVector) {
        this.centerVector = centerVector;
    }

    public Optional<Integer> getPlayerLimit() {
        return Optional.ofNullable(this.playerLimit);
    }

    public void setPlayerLimit(Integer playerLimit) {
        this.playerLimit = playerLimit;
    }

    public Optional<Integer> getCountdownSeconds() {
        return Optional.ofNullable(this.countdownSeconds);
    }

    public void setCountdownSeconds(Integer countdownSeconds) {
        this.countdownSeconds = countdownSeconds;
    }

    public List<Vector3d> getSpawnPoints() {
        return this.spawnPoints;
    }

    public Optional<Integer> getChestMidpoint() {
        return Optional.ofNullable(this.chestMidpoint);
    }

    public void setChestMidpoint(Integer chestMidpoint) {
        this.chestMidpoint = chestMidpoint;
    }

    public Optional<Integer> getChestRange() {
        return Optional.ofNullable(this.chestRange);
    }

    public void setChestRange(Integer chestRange) {
        this.chestRange = chestRange;
    }

    public void setItemConfig(ItemConfig itemConfig) {
        this.itemConfig = itemConfig;
    }

    public ItemConfig getItemConfig() {
        if (this.itemConfig == null) {
            this.itemConfig = new ItemConfig();
        }
        return this.itemConfig;
    }

    public Area getBlockArea() {
        if (this.blockArea == null) {
            this.blockArea = new Area();
        }
        return this.blockArea;
    }

    public List<MobSpawnArea> getMobSpawnAreas() {
        return this.mobSpawnAreas;
    }

    public Map<String, Integer> getEventIntervals() {
        return this.eventIntervals;
    }

    public List<BlockSnapshot> getBlocks() {
        return this.blocks;
    }

    public void setBlocks(List<BlockSnapshot> blocks) {
        this.blocks = blocks;
    }

    static {
        try {
            OBJECT_MAPPER = ObjectMapper.forClass(GameConfig.class);
        }
        catch (ObjectMappingException e) {
            throw new RuntimeException(e);
        }
    }
}

