/*
 * Decompiled with CFR 0.152.
 */
package io.github.m0pt0pmatt.survivalgames.data;

import com.google.common.base.Preconditions;
import java.time.Duration;
import java.time.temporal.ChronoUnit;
import ninja.leaping.configurate.objectmapping.Setting;
import ninja.leaping.configurate.objectmapping.serialize.ConfigSerializable;

@ConfigSerializable
public class WorldBorderStage {
    @Setting(value="waitTime")
    private Long waitTime;
    @Setting(value="movementTime")
    private Long movementTime;
    @Setting(value="diameterDelta")
    private Integer diameterDelta;

    public Duration getWaitTime() {
        return Duration.of(this.waitTime, ChronoUnit.SECONDS);
    }

    public void setWaitTime(Duration waitTime) {
        this.waitTime = ((Duration)Preconditions.checkNotNull((Object)waitTime, (Object)"waitTime")).getSeconds();
    }

    public void setWaitTime(Long waitTime) {
        this.waitTime = (Long)Preconditions.checkNotNull((Object)waitTime, (Object)"waitTime");
    }

    public Duration getMovementTime() {
        return Duration.of(this.movementTime, ChronoUnit.SECONDS);
    }

    public void setMovementTime(Duration movementTime) {
        this.movementTime = ((Duration)Preconditions.checkNotNull((Object)movementTime, (Object)"movementTime")).getSeconds();
    }

    public void setMovementTime(Long movementTime) {
        this.movementTime = (Long)Preconditions.checkNotNull((Object)movementTime, (Object)"movementTime");
    }

    public int getDiameterDelta() {
        return this.diameterDelta;
    }

    public void setDiameterDelta(Integer diameterDelta) {
        this.diameterDelta = (Integer)Preconditions.checkNotNull((Object)diameterDelta, (Object)"diameterDelta");
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private Duration waitTime;
        private Duration movementTime;
        private Integer diameterDelta;

        private Builder() {
        }

        public Builder waitTime(Duration waitTime) {
            this.waitTime = waitTime;
            return this;
        }

        public Builder movementTime(Duration movementTime) {
            this.movementTime = movementTime;
            return this;
        }

        public Builder diameterDelta(Integer diameterDelta) {
            this.diameterDelta = diameterDelta;
            return this;
        }

        public WorldBorderStage build() {
            WorldBorderStage stage = new WorldBorderStage();
            stage.setWaitTime(this.waitTime);
            stage.setMovementTime(this.movementTime);
            stage.setDiameterDelta(this.diameterDelta);
            return stage;
        }
    }
}

