/*
 * Decompiled with CFR 0.152.
 */
package io.github.m0pt0pmatt.survivalgames.game;

import com.flowpowered.math.vector.Vector3d;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import org.spongepowered.api.data.key.Keys;
import org.spongepowered.api.data.value.mutable.MutableBoundedValue;
import org.spongepowered.api.data.value.mutable.Value;
import org.spongepowered.api.entity.Entity;
import org.spongepowered.api.entity.living.player.Player;
import org.spongepowered.api.entity.living.player.gamemode.GameMode;
import org.spongepowered.api.item.inventory.Inventory;
import org.spongepowered.api.item.inventory.ItemStack;
import org.spongepowered.api.scoreboard.Scoreboard;
import org.spongepowered.api.text.Text;
import org.spongepowered.api.world.Location;
import org.spongepowered.api.world.World;

public final class PlayerRestorer {
    private final Value<Text> displayNameData;
    private final List<ItemStack> enderChestInventory;
    private final Value<GameMode> gameModeData;
    private final Scoreboard scoreboard;
    private final MutableBoundedValue<Integer> foodLevel;
    private final MutableBoundedValue<Double> exhaustion;
    private final MutableBoundedValue<Double> saturation;
    private final List<ItemStack> inventory;
    private final MutableBoundedValue<Double> health;
    private final MutableBoundedValue<Double> maxHealth;
    private final Vector3d headRotation;
    private final Entity vehicle;
    private final List<Entity> passengers;
    private final Vector3d rotation;
    private final Vector3d velocity;
    private final Location<World> location;

    public PlayerRestorer(Player player) {
        this.displayNameData = player.getDisplayNameData().displayName().copy();
        this.enderChestInventory = this.inventory(player.getEnderChestInventory());
        this.gameModeData = player.getGameModeData().type().copy();
        this.scoreboard = player.getScoreboard();
        this.foodLevel = player.getFoodData().foodLevel();
        this.exhaustion = player.getFoodData().exhaustion();
        this.saturation = player.getFoodData().saturation();
        this.inventory = this.inventory((Inventory)player.getInventory());
        this.health = player.getHealthData().health().copy();
        this.maxHealth = player.getHealthData().maxHealth().copy();
        this.headRotation = player.getHeadRotation().clone();
        this.vehicle = player.getVehicle().orElse(null);
        this.passengers = player.getPassengers();
        this.rotation = player.getRotation().clone();
        this.velocity = player.getVelocity().clone();
        this.location = player.getLocation();
    }

    private ArrayList<ItemStack> inventory(Inventory inventory) {
        ArrayList<ItemStack> items = new ArrayList<ItemStack>(inventory.size());
        inventory.slots().forEach(i -> items.add(i.peek().orElse(null)));
        inventory.clear();
        return items;
    }

    private void restoreInventory(Inventory inventory, List<ItemStack> items) {
        inventory.clear();
        Iterator<ItemStack> ii = items.iterator();
        Iterator si = inventory.slots().iterator();
        while (ii.hasNext()) {
            ItemStack item = ii.next();
            Inventory slot = (Inventory)si.next();
            if (item == null) continue;
            slot.set(item);
        }
    }

    public void restore(Player player) {
        player.offer(Keys.DISPLAY_NAME, this.displayNameData.get());
        this.restoreInventory(player.getEnderChestInventory(), this.enderChestInventory);
        player.offer(Keys.GAME_MODE, this.gameModeData.get());
        player.setScoreboard(this.scoreboard);
        player.offer(Keys.FOOD_LEVEL, this.foodLevel.get());
        player.offer(Keys.EXHAUSTION, this.exhaustion.get());
        player.offer(Keys.SATURATION, this.saturation.get());
        this.restoreInventory((Inventory)player.getInventory(), this.inventory);
        player.offer(Keys.HEALTH, this.health.get());
        player.offer(Keys.MAX_HEALTH, this.maxHealth.get());
        player.setHeadRotation(this.headRotation);
        Optional.ofNullable(this.vehicle).ifPresent(arg_0 -> ((Player)player).setVehicle(arg_0));
        if (this.passengers.size() > 0) {
            player.clearPassengers();
            this.passengers.forEach(arg_0 -> ((Player)player).addPassenger(arg_0));
        }
        player.setRotation(this.rotation);
        player.setVelocity(this.velocity);
        player.setLocation(this.location);
    }
}

