/*
 * Decompiled with CFR 0.152.
 */
package io.github.m0pt0pmatt.survivalgames.game;

import com.google.common.base.Preconditions;
import io.github.m0pt0pmatt.survivalgames.Util;
import io.github.m0pt0pmatt.survivalgames.data.GameConfig;
import io.github.m0pt0pmatt.survivalgames.game.PlayerRestorer;
import io.github.m0pt0pmatt.survivalgames.game.SurvivalGameRunningState;
import io.github.m0pt0pmatt.survivalgames.game.SurvivalGameState;
import io.github.m0pt0pmatt.survivalgames.scoreboard.ScoreboardRepository;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.block.tileentity.CommandBlock;
import org.spongepowered.api.command.CommandSource;
import org.spongepowered.api.entity.living.player.Player;
import org.spongepowered.api.text.Text;
import org.spongepowered.api.text.channel.MessageChannel;
import org.spongepowered.api.text.format.TextColors;

public class SurvivalGame {
    SurvivalGameState state;
    SurvivalGameRunningState runningState;
    private final String name;
    private final GameConfig config;
    private final Set<UUID> playerUUIDs;
    private final Set<UUID> spectatorUUIDs;
    private final Set<CommandBlock> commandBlocks;
    private final Set<UUID> activeMobSpawners;
    private final Set<UUID> activeEventIntervals;
    private final Map<UUID, PlayerRestorer> playerSnapshots;
    private final MessageChannel messageChannel;

    public SurvivalGame(String name, GameConfig config) {
        this.name = (String)Preconditions.checkNotNull((Object)name);
        this.state = SurvivalGameState.STOPPED;
        this.runningState = SurvivalGameRunningState.STOPPED;
        this.config = (GameConfig)Preconditions.checkNotNull((Object)config);
        this.playerUUIDs = new HashSet<UUID>();
        this.spectatorUUIDs = new HashSet<UUID>();
        this.commandBlocks = new HashSet<CommandBlock>();
        this.activeMobSpawners = new HashSet<UUID>();
        this.activeEventIntervals = new HashSet<UUID>();
        this.playerSnapshots = new HashMap<UUID, PlayerRestorer>();
        this.messageChannel = MessageChannel.combined((MessageChannel[])new MessageChannel[]{MessageChannel.TO_CONSOLE, () -> Stream.of(this.playerUUIDs, this.spectatorUUIDs).flatMap(Collection::stream).map(uuid -> Sponge.getServer().getPlayer(uuid)).filter(Optional::isPresent).map(Optional::get).collect(Collectors.toList())});
    }

    public SurvivalGame(String name) {
        this(name, new GameConfig());
    }

    public String getName() {
        return this.name;
    }

    public SurvivalGameState getState() {
        return this.state;
    }

    public SurvivalGameRunningState getRunningState() {
        return this.runningState;
    }

    public GameConfig getConfig() {
        return this.config;
    }

    public void forEachPlayer(Consumer<? super UUID> action) {
        this.playerUUIDs.forEach(action);
    }

    public void addPlayer(Player player) {
        this.playerUUIDs.add(player.getUniqueId());
        this.sendMessage(Text.of((Object[])new Object[]{player.getName(), " joined the game"}));
        ScoreboardRepository.get(this).ifPresent(s -> {
            s.getObjective("ssg-" + this.getName()).ifPresent(o -> o.getOrCreateScore((Text)Text.of((String)player.getName())).setScore(0));
            player.setScoreboard(s);
        });
    }

    public void clearPlayerUUIDs() {
        this.playerUUIDs.clear();
    }

    public void removePlayer(UUID uuid) {
        this.playerUUIDs.remove(uuid);
    }

    public int getPlayerCount() {
        return this.playerUUIDs.size();
    }

    public boolean containsPlayer(UUID uuid) {
        return this.playerUUIDs.contains(uuid);
    }

    public void forEachSpectator(Consumer<? super UUID> action) {
        this.spectatorUUIDs.forEach(action);
    }

    public void addSpectator(Player player) {
        this.spectatorUUIDs.add(player.getUniqueId());
        this.messageChannel.send(Text.of((Object[])new Object[]{player.getName(), " now spectating the game"}));
    }

    public boolean containsSpectator(UUID uuid) {
        return this.spectatorUUIDs.contains(uuid);
    }

    public void removeSpectator(UUID uuid) {
        this.spectatorUUIDs.remove(uuid);
    }

    public void clearSpectatorUUIDs() {
        this.spectatorUUIDs.clear();
    }

    public Set<CommandBlock> getCommandBlocks() {
        return this.commandBlocks;
    }

    public Set<UUID> getActiveMobSpawners() {
        return this.activeMobSpawners;
    }

    public Set<UUID> getActiveEventIntervals() {
        return this.activeEventIntervals;
    }

    public Map<UUID, PlayerRestorer> getPlayerSnapshots() {
        return this.playerSnapshots;
    }

    public MessageChannel getMessageChannel() {
        return this.messageChannel;
    }

    public void sendMessage(Text text) {
        this.messageChannel.send(Text.of((Object[])new Object[]{Util.gamePrefix(this), TextColors.GRAY, text}));
    }

    public Text printPlayers() {
        return Text.joinWith((Text)Text.of((char)'\n'), (Iterable)this.playerUUIDs.stream().map(id -> Sponge.getServer().getPlayer(id)).filter(Optional::isPresent).map(Optional::get).map(CommandSource::getName).map(Text::of).collect(Collectors.toList()));
    }
}

