/*
 * Decompiled with CFR 0.152.
 */
package io.github.m0pt0pmatt.survivalgames.game;

import io.github.m0pt0pmatt.survivalgames.game.SurvivalGame;
import java.util.Collection;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;

public final class SurvivalGameRepository {
    private static final Map<String, SurvivalGame> MAP = new ConcurrentHashMap<String, SurvivalGame>();

    private SurvivalGameRepository() {
    }

    public static void put(String name, SurvivalGame survivalGame) {
        MAP.put(name, survivalGame);
    }

    public static Optional<SurvivalGame> get(String name) {
        return Optional.ofNullable(MAP.get(name));
    }

    public static Collection<SurvivalGame> values() {
        return MAP.values();
    }

    public static boolean contains(String name) {
        return MAP.containsKey(name);
    }

    public static SurvivalGame remove(String name) {
        return MAP.remove(name);
    }

    public static SurvivalGame remove(SurvivalGame game) {
        return MAP.remove(game.getName());
    }
}

