/*
 * Decompiled with CFR 0.152.
 */
package io.github.m0pt0pmatt.survivalgames.game;

import io.github.m0pt0pmatt.survivalgames.data.GameConfig;
import io.github.m0pt0pmatt.survivalgames.event.GameDeathmatchEvent;
import io.github.m0pt0pmatt.survivalgames.event.GameReadyEvent;
import io.github.m0pt0pmatt.survivalgames.event.GameStartedEvent;
import io.github.m0pt0pmatt.survivalgames.event.GameStoppedEvent;
import io.github.m0pt0pmatt.survivalgames.game.SurvivalGame;
import io.github.m0pt0pmatt.survivalgames.game.SurvivalGameRunningState;
import io.github.m0pt0pmatt.survivalgames.game.SurvivalGameState;
import io.github.m0pt0pmatt.survivalgames.task.AdjustScoreboardForStartTask;
import io.github.m0pt0pmatt.survivalgames.task.CleanStateTask;
import io.github.m0pt0pmatt.survivalgames.task.ClearEntitiesTask;
import io.github.m0pt0pmatt.survivalgames.task.ClearPlayersTask;
import io.github.m0pt0pmatt.survivalgames.task.ClearWorldBorderTask;
import io.github.m0pt0pmatt.survivalgames.task.CreateCageSnapshotsTask;
import io.github.m0pt0pmatt.survivalgames.task.CreateDeathmatchBorderTask;
import io.github.m0pt0pmatt.survivalgames.task.CreateWorldBorderTask;
import io.github.m0pt0pmatt.survivalgames.task.FillChestsTask;
import io.github.m0pt0pmatt.survivalgames.task.LoadChunksTask;
import io.github.m0pt0pmatt.survivalgames.task.RestoreBlocksTask;
import io.github.m0pt0pmatt.survivalgames.task.SetCommandBlocksTask;
import io.github.m0pt0pmatt.survivalgames.task.StartEventIntervalsTask;
import io.github.m0pt0pmatt.survivalgames.task.StartMobSpawnersTask;
import io.github.m0pt0pmatt.survivalgames.task.StopEventIntervalsTask;
import io.github.m0pt0pmatt.survivalgames.task.StopMobSpawnersTask;
import io.github.m0pt0pmatt.survivalgames.task.Task;
import io.github.m0pt0pmatt.survivalgames.task.player.ClearScoreBoardTask;
import io.github.m0pt0pmatt.survivalgames.task.player.CreateCountdownTask;
import io.github.m0pt0pmatt.survivalgames.task.player.CreateScoreboardTask;
import io.github.m0pt0pmatt.survivalgames.task.player.HealPlayersTask;
import io.github.m0pt0pmatt.survivalgames.task.player.RestorePlayerTask;
import io.github.m0pt0pmatt.survivalgames.task.player.SnapshotPlayerTask;
import io.github.m0pt0pmatt.survivalgames.task.player.SpawnPlayersTask;
import io.github.m0pt0pmatt.survivalgames.task.player.SpawnSpectatorsTask;
import java.util.Arrays;
import java.util.List;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.event.Event;
import org.spongepowered.api.util.TextMessageException;

public class SurvivalGameStateManager {
    private static final List<Task> READY_TASKS = Arrays.asList(RestoreBlocksTask.getInstance(), CreateScoreboardTask.getInstance());
    private static final List<Task> START_TASKS = Arrays.asList(LoadChunksTask.getInstance(), ClearEntitiesTask.getInstance(), SetCommandBlocksTask.getInstance(), FillChestsTask.getInstance(), CreateCageSnapshotsTask.getInstance(), SnapshotPlayerTask.getInstance(), SpawnPlayersTask.getInstance(), HealPlayersTask.getInstance(), SpawnSpectatorsTask.getInstance(), AdjustScoreboardForStartTask.getInstance(), CreateCountdownTask.getInstance(), CreateWorldBorderTask.getInstance(), StartEventIntervalsTask.getInstance(), StartMobSpawnersTask.getInstance());
    private static final List<Task> DEATH_MATCH_TASKS = Arrays.asList(CreateCageSnapshotsTask.getInstance(), SpawnPlayersTask.getInstance(), CreateCountdownTask.getInstance(), CreateDeathmatchBorderTask.getInstance());
    private static final List<Task> STOP_TASKS = Arrays.asList(RestorePlayerTask.getInstance(), ClearScoreBoardTask.getInstance(), ClearWorldBorderTask.getInstance(), ClearPlayersTask.getInstance(), StopMobSpawnersTask.getInstance(), StopEventIntervalsTask.getInstance(), CleanStateTask.getInstance());

    public static void ready(SurvivalGame survivalGame) {
        SurvivalGameStateManager.checkConfig(survivalGame.getConfig());
        try {
            SurvivalGameState oldState = survivalGame.getState();
            SurvivalGameStateManager.executeTasks(READY_TASKS, survivalGame);
            survivalGame.state = SurvivalGameState.READY;
            survivalGame.runningState = SurvivalGameRunningState.STOPPED;
            Sponge.getEventManager().post((Event)new GameReadyEvent(survivalGame, oldState));
        }
        catch (TextMessageException e) {
            e.printStackTrace();
        }
    }

    public static void start(SurvivalGame survivalGame) {
        SurvivalGameStateManager.checkConfig(survivalGame.getConfig());
        try {
            SurvivalGameState oldState = survivalGame.getState();
            SurvivalGameStateManager.executeTasks(START_TASKS, survivalGame);
            survivalGame.state = SurvivalGameState.RUNNING;
            survivalGame.runningState = SurvivalGameRunningState.IN_PROGRESS;
            Sponge.getEventManager().post((Event)new GameStartedEvent(survivalGame, oldState));
        }
        catch (TextMessageException e) {
            e.printStackTrace();
        }
    }

    public static void deathMatch(SurvivalGame survivalGame) {
        try {
            SurvivalGameStateManager.executeTasks(DEATH_MATCH_TASKS, survivalGame);
            survivalGame.state = SurvivalGameState.RUNNING;
            survivalGame.runningState = SurvivalGameRunningState.DEATH_MATCH;
            Sponge.getEventManager().post((Event)new GameDeathmatchEvent(survivalGame));
        }
        catch (TextMessageException e) {
            e.printStackTrace();
        }
    }

    public static void stop(SurvivalGame survivalGame) {
        try {
            SurvivalGameState oldState = survivalGame.getState();
            SurvivalGameStateManager.executeTasks(STOP_TASKS, survivalGame);
            survivalGame.state = SurvivalGameState.STOPPED;
            survivalGame.runningState = SurvivalGameRunningState.STOPPED;
            Sponge.getEventManager().post((Event)new GameStoppedEvent(survivalGame, oldState));
        }
        catch (TextMessageException e) {
            e.printStackTrace();
        }
    }

    private static void checkConfig(GameConfig config) {
        if (config.getSpawnPoints().isEmpty()) {
            throw new IllegalArgumentException("No spawn points set.");
        }
        String worldName = config.getWorldName().orElseThrow(() -> new IllegalArgumentException("World name is not set."));
        if (!Sponge.getServer().getWorld(worldName).isPresent()) {
            throw new IllegalArgumentException("World " + worldName + " does not exist.");
        }
        if (!config.getBlockArea().getLesserBoundary().isPresent() || !config.getBlockArea().getGreaterBoundary().isPresent()) {
            throw new IllegalArgumentException("Boundaries are not set.");
        }
        String exitWorldName = config.getExitWorldName().orElseThrow(() -> new IllegalArgumentException("Exit world name is not set."));
        if (!Sponge.getServer().getWorld(exitWorldName).isPresent()) {
            throw new IllegalArgumentException("Exit world " + worldName + " does not exist.");
        }
        if (!config.getExitVector().isPresent()) {
            throw new IllegalArgumentException("Exit vector is not set.");
        }
        if (!config.getCenterVector().isPresent()) {
            throw new IllegalArgumentException("Center vector is not set.");
        }
        if (!config.getCountdownSeconds().isPresent()) {
            throw new IllegalArgumentException("Countdown seconds are not set.");
        }
        if (!config.getPlayerLimit().isPresent()) {
            throw new IllegalArgumentException("Player limit is not set.");
        }
        if (!config.getChestMidpoint().isPresent()) {
            throw new IllegalArgumentException("Chest midpoint is not set.");
        }
        if (!config.getChestRange().isPresent()) {
            throw new IllegalArgumentException("Chest range is not set.");
        }
    }

    private static void executeTasks(List<Task> tasks, SurvivalGame survivalGame) throws TextMessageException {
        for (Task task : tasks) {
            task.execute(survivalGame);
        }
    }
}

