/*
 * Decompiled with CFR 0.152.
 */
package io.github.m0pt0pmatt.survivalgames.interval;

import io.github.m0pt0pmatt.survivalgames.SurvivalGamesPlugin;
import io.github.m0pt0pmatt.survivalgames.event.IntervalEvent;
import io.github.m0pt0pmatt.survivalgames.game.SurvivalGame;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.block.BlockSnapshot;
import org.spongepowered.api.event.Event;
import org.spongepowered.api.scheduler.SpongeExecutorService;
import org.spongepowered.api.world.Location;
import org.spongepowered.api.world.World;

public final class ActiveIntervalRepository {
    private static final Map<UUID, SpongeExecutorService.SpongeFuture> FUTURE_MAP = new ConcurrentHashMap<UUID, SpongeExecutorService.SpongeFuture>();
    private static final Map<Location<World>, BlockSnapshot> BLOCK_MAP = new ConcurrentHashMap<Location<World>, BlockSnapshot>();

    private ActiveIntervalRepository() {
    }

    public static UUID start(SurvivalGame survivalGame, String intervalName, int intervalSeconds) {
        SpongeExecutorService.SpongeFuture future = SurvivalGamesPlugin.SYNC_EXECUTOR.scheduleAtFixedRate(() -> Sponge.getEventManager().post((Event)new IntervalEvent(survivalGame, intervalName)), 0L, (long)intervalSeconds, TimeUnit.SECONDS);
        UUID uuid = UUID.randomUUID();
        FUTURE_MAP.put(uuid, future);
        return uuid;
    }

    public static void stop(UUID uuid) {
        SpongeExecutorService.SpongeFuture future = FUTURE_MAP.remove(uuid);
        if (future != null) {
            future.cancel(true);
        }
    }

    public static BlockSnapshot getSnapshot(Location<World> location) {
        BlockSnapshot blockSnapshot = BLOCK_MAP.get(location);
        if (blockSnapshot == null) {
            blockSnapshot = location.createSnapshot();
            BLOCK_MAP.put(location, blockSnapshot);
        }
        return blockSnapshot;
    }
}

