/*
 * Decompiled with CFR 0.152.
 */
package io.github.m0pt0pmatt.survivalgames.listener;

import io.github.m0pt0pmatt.survivalgames.event.PlayerDeathEvent;
import io.github.m0pt0pmatt.survivalgames.game.SurvivalGame;
import io.github.m0pt0pmatt.survivalgames.game.SurvivalGameRepository;
import io.github.m0pt0pmatt.survivalgames.game.WinChecker;
import io.github.m0pt0pmatt.survivalgames.task.UpdateScoreBoardTask;
import io.github.m0pt0pmatt.survivalgames.task.player.ExitPlayerTask;
import io.github.m0pt0pmatt.survivalgames.task.player.HealPlayersTask;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.data.key.Keys;
import org.spongepowered.api.entity.Entity;
import org.spongepowered.api.entity.EntityTypes;
import org.spongepowered.api.entity.living.player.Player;
import org.spongepowered.api.event.Event;
import org.spongepowered.api.event.Listener;
import org.spongepowered.api.event.cause.Cause;
import org.spongepowered.api.event.cause.entity.damage.source.EntityDamageSource;
import org.spongepowered.api.event.entity.DamageEntityEvent;
import org.spongepowered.api.item.inventory.ItemStack;
import org.spongepowered.api.item.inventory.type.CarriedInventory;
import org.spongepowered.api.text.Text;
import org.spongepowered.api.util.TextMessageException;
import org.spongepowered.api.world.World;

public class PlayerDeathListener {
    private static final PlayerDeathListener INSTANCE = new PlayerDeathListener();

    private PlayerDeathListener() {
    }

    @Listener
    public void onPlayerDamage(DamageEntityEvent event) {
        Entity entity = event.getTargetEntity();
        if (!(entity instanceof Player)) {
            return;
        }
        Player player = (Player)entity;
        if (!event.willCauseDeath()) {
            return;
        }
        for (SurvivalGame survivalGame : SurvivalGameRepository.values()) {
            if (!survivalGame.containsPlayer(player.getUniqueId())) continue;
            PlayerDeathListener.performDeadPlayer(survivalGame, player, event.getCause());
            event.setCancelled(true);
            break;
        }
    }

    private static void performDeadPlayer(SurvivalGame survivalGame, Player player, Cause cause) {
        ItemStack item;
        Player killingPlayer = cause.first(EntityDamageSource.class).map(EntityDamageSource::getSource).filter(e -> e instanceof Player).orElse(null);
        try {
            UpdateScoreBoardTask.getInstance().update(survivalGame, player, killingPlayer);
        }
        catch (TextMessageException e2) {
            e2.printStackTrace();
        }
        World world = player.getWorld();
        CarriedInventory inventory = player.getInventory();
        while ((item = (ItemStack)inventory.poll().orElse(null)) != null) {
            Entity entity = world.createEntity(EntityTypes.ITEM, player.getLocation().getPosition());
            entity.offer(Keys.REPRESENTED_ITEM, (Object)item.createSnapshot());
            world.spawnEntity(entity);
        }
        try {
            ExitPlayerTask.getInstance().execute(survivalGame, player);
        }
        catch (TextMessageException e3) {
            e3.printStackTrace();
        }
        try {
            HealPlayersTask.getInstance().execute(survivalGame, player);
        }
        catch (TextMessageException e4) {
            e4.printStackTrace();
        }
        survivalGame.removePlayer(player.getUniqueId());
        Sponge.getEventManager().post((Event)new PlayerDeathEvent(cause, survivalGame, player));
        player.sendMessage((Text)Text.of((String)"You were killed. Wait for the game to end."));
        try {
            WinChecker.checkWin(survivalGame);
        }
        catch (TextMessageException e5) {
            e5.printStackTrace();
        }
    }

    public static PlayerDeathListener getInstance() {
        return INSTANCE;
    }
}

