/*
 * Decompiled with CFR 0.152.
 */
package io.github.m0pt0pmatt.survivalgames.listener;

import com.google.common.collect.ImmutableList;
import io.github.m0pt0pmatt.survivalgames.SurvivalGamesPlugin;
import io.github.m0pt0pmatt.survivalgames.event.IntervalEvent;
import io.github.m0pt0pmatt.survivalgames.event.PlayerEvent;
import io.github.m0pt0pmatt.survivalgames.event.SurvivalGameEvent;
import io.github.m0pt0pmatt.survivalgames.interval.ActiveIntervalRepository;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.apache.commons.lang3.ClassUtils;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.block.BlockSnapshot;
import org.spongepowered.api.block.BlockState;
import org.spongepowered.api.block.BlockTypes;
import org.spongepowered.api.block.tileentity.CommandBlock;
import org.spongepowered.api.command.CommandSource;
import org.spongepowered.api.data.value.mutable.Value;
import org.spongepowered.api.entity.living.player.Player;
import org.spongepowered.api.event.Listener;
import org.spongepowered.api.world.BlockChangeFlags;
import org.spongepowered.api.world.Location;
import org.spongepowered.api.world.World;

public class SurvivalGameEventListener {
    private static final SurvivalGameEventListener INSTANCE = new SurvivalGameEventListener();
    private static final String COMMAND_BLOCK_STRING = "/ssg event ";
    private static final List<Class<?>> survivalGameClasses = ClassUtils.getAllSuperclasses(SurvivalGameEvent.class);

    private SurvivalGameEventListener() {
    }

    @Listener
    public void fireCommandBlocks(SurvivalGameEvent event) {
        event.getSurvivalGame().getCommandBlocks().forEach(c -> this.handleCommandBlock((CommandBlock)c, event));
    }

    private void handleCommandBlock(CommandBlock commandBlock, SurvivalGameEvent event) {
        Value storedCommand = commandBlock.storedCommand();
        if (!storedCommand.exists()) {
            return;
        }
        String[] parts = ((String)storedCommand.get()).trim().split("\\s+");
        if (parts.length < 3) {
            return;
        }
        if (!parts[0].equalsIgnoreCase("/ssg") || !parts[1].equalsIgnoreCase("event")) {
            return;
        }
        String eventName = parts[2];
        List classes = ImmutableList.builder().add(((Object)((Object)event)).getClass()).addAll((Iterable)ClassUtils.getAllSuperclasses(((Object)((Object)event)).getClass())).build().stream().filter(c -> !survivalGameClasses.contains(c)).map(Class::getSimpleName).collect(Collectors.toList());
        if (!classes.contains(eventName)) {
            return;
        }
        if (parts.length > 3) {
            String internalCommand = ((String)storedCommand.get()).substring(COMMAND_BLOCK_STRING.length());
            Player source = null;
            if (event instanceof PlayerEvent) {
                source = ((PlayerEvent)event).getPlayer();
            } else if (event instanceof IntervalEvent) {
                source = commandBlock;
            }
            if (source != null) {
                Sponge.getCommandManager().process((CommandSource)source, internalCommand);
            }
        }
        BlockSnapshot snapshot = ActiveIntervalRepository.getSnapshot((Location<World>)commandBlock.getLocation());
        commandBlock.getLocation().setBlock((BlockState)BlockState.builder().blockType(BlockTypes.REDSTONE_TORCH).build(), BlockChangeFlags.ALL);
        SurvivalGamesPlugin.SYNC_EXECUTOR.schedule(() -> snapshot.restore(true, BlockChangeFlags.ALL), 1L, TimeUnit.SECONDS);
    }

    public static SurvivalGameEventListener getInstance() {
        return INSTANCE;
    }
}

