/*
 * Decompiled with CFR 0.152.
 */
package io.github.m0pt0pmatt.survivalgames.mobspawn;

import io.github.m0pt0pmatt.survivalgames.SurvivalGamesPlugin;
import io.github.m0pt0pmatt.survivalgames.data.MobSpawnArea;
import io.github.m0pt0pmatt.survivalgames.game.SurvivalGame;
import io.github.m0pt0pmatt.survivalgames.mobspawn.MobSpawnRunnable;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import org.spongepowered.api.scheduler.SpongeExecutorService;
import org.spongepowered.api.world.World;

public final class ActiveMobSpawnRepository {
    private static final Map<UUID, SpongeExecutorService.SpongeFuture> FUTURE_MAP = new ConcurrentHashMap<UUID, SpongeExecutorService.SpongeFuture>();

    private ActiveMobSpawnRepository() {
    }

    public static UUID start(SurvivalGame survivalGame, MobSpawnArea mobSpawnArea, World world) {
        int millisecondsPerSpawn = mobSpawnArea.getSpawnRatePerMinute().map(integer -> 60000 / integer).orElse(0);
        SpongeExecutorService.SpongeFuture future = SurvivalGamesPlugin.SYNC_EXECUTOR.scheduleAtFixedRate((Runnable)new MobSpawnRunnable(survivalGame, mobSpawnArea, world), 0L, (long)millisecondsPerSpawn, TimeUnit.MILLISECONDS);
        FUTURE_MAP.put(mobSpawnArea.getId(), future);
        return mobSpawnArea.getId();
    }

    public static void stop(UUID uuid) {
        SpongeExecutorService.SpongeFuture future = FUTURE_MAP.remove(uuid);
        if (future != null) {
            future.cancel(true);
        }
    }
}

