/*
 * Decompiled with CFR 0.152.
 */
package io.github.m0pt0pmatt.survivalgames.mobspawn;

import com.flowpowered.math.vector.Vector3d;
import com.google.common.base.Preconditions;
import io.github.m0pt0pmatt.survivalgames.data.MobSpawnArea;
import io.github.m0pt0pmatt.survivalgames.event.MobSpawnedEvent;
import io.github.m0pt0pmatt.survivalgames.game.SurvivalGame;
import java.util.Optional;
import java.util.Random;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.entity.Entity;
import org.spongepowered.api.entity.EntityType;
import org.spongepowered.api.event.Event;
import org.spongepowered.api.world.Location;
import org.spongepowered.api.world.World;

class MobSpawnRunnable
implements Runnable {
    private final SurvivalGame survivalGame;
    private final MobSpawnArea mobSpawnArea;
    private final World world;
    private static final Random random = new Random();

    MobSpawnRunnable(SurvivalGame survivalGame, MobSpawnArea mobSpawnArea, World world) {
        this.survivalGame = (SurvivalGame)Preconditions.checkNotNull((Object)survivalGame, (Object)"survivalGame");
        this.mobSpawnArea = (MobSpawnArea)Preconditions.checkNotNull((Object)mobSpawnArea, (Object)"mobSpawnArea");
        this.world = (World)Preconditions.checkNotNull((Object)world, (Object)"world");
    }

    @Override
    public void run() {
        Optional<Vector3d> lesserBoundary = this.mobSpawnArea.getLesserBoundary();
        Optional<Vector3d> greaterBoundary = this.mobSpawnArea.getGreaterBoundary();
        Optional<EntityType> entityType = this.mobSpawnArea.getEntityType();
        if (lesserBoundary.isPresent() && greaterBoundary.isPresent() && entityType.isPresent()) {
            double xDiff = greaterBoundary.get().getX() - lesserBoundary.get().getX();
            double yDiff = greaterBoundary.get().getY() - lesserBoundary.get().getY();
            double zDiff = greaterBoundary.get().getZ() - lesserBoundary.get().getZ();
            Location location = this.world.getLocation(lesserBoundary.get().getX() + (double)random.nextInt((int)xDiff), lesserBoundary.get().getY() + (double)random.nextInt((int)yDiff), lesserBoundary.get().getZ() + (double)random.nextInt((int)zDiff));
            Entity entity = this.world.createEntity(entityType.get(), location.getPosition());
            MobSpawnedEvent event = new MobSpawnedEvent(this.survivalGame, entity);
            boolean spawned = this.world.spawnEntity(entity);
            if (spawned) {
                Sponge.getEventManager().post((Event)event);
            }
        }
    }
}

