/*
 * Decompiled with CFR 0.152.
 */
package io.github.m0pt0pmatt.survivalgames.schedule;

import com.google.common.collect.ImmutableMap;
import io.github.m0pt0pmatt.survivalgames.SurvivalGamesPlugin;
import io.github.m0pt0pmatt.survivalgames.data.Schedule;
import io.github.m0pt0pmatt.survivalgames.data.WorldBorderStage;
import io.github.m0pt0pmatt.survivalgames.game.SurvivalGame;
import io.github.m0pt0pmatt.survivalgames.game.SurvivalGameRunningState;
import io.github.m0pt0pmatt.survivalgames.game.SurvivalGameState;
import io.github.m0pt0pmatt.survivalgames.game.SurvivalGameStateManager;
import java.time.Duration;
import java.time.Instant;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.text.Text;
import org.spongepowered.api.world.World;
import org.spongepowered.api.world.WorldBorder;

class ScheduleRunner
implements Runnable {
    private Map<ScheduleState, Runnable> stateFunctions = ImmutableMap.builder().put((Object)ScheduleState.STOPPED, this::stopped).put((Object)ScheduleState.LOBBY, this::lobby).put((Object)ScheduleState.LOBBY_COUNTDOWN, this::lobbyCountdown).put((Object)ScheduleState.RUNNING, this::running).build();
    private final SurvivalGame survivalGame;
    private final Schedule schedule;
    private SurvivalGameState savedState;
    private SurvivalGameRunningState savedRunningState;
    private Instant startTime;
    private boolean shouldRun = true;
    private ScheduleState state;
    private int borderIndex = 0;
    private boolean isDeathmatch = false;

    ScheduleRunner(SurvivalGame survivalGame, Schedule schedule) {
        this.survivalGame = survivalGame;
        this.schedule = schedule;
        this.setState(survivalGame.getState());
        this.setRunningState(survivalGame.getRunningState());
    }

    private void setState(SurvivalGameState currentState) {
        ScheduleState newState = null;
        if (currentState.equals((Object)SurvivalGameState.RUNNING)) {
            newState = ScheduleState.RUNNING;
        } else if (currentState.equals((Object)SurvivalGameState.STOPPED)) {
            newState = ScheduleState.STOPPED;
        } else if (currentState.equals((Object)SurvivalGameState.READY)) {
            newState = ScheduleState.LOBBY;
        }
        this.toState(newState, null, null);
        this.savedState = currentState;
    }

    private void setRunningState(SurvivalGameRunningState currentState) {
        SurvivalGameRunningState newState = null;
        if (currentState.equals((Object)SurvivalGameRunningState.STOPPED)) {
            newState = SurvivalGameRunningState.STOPPED;
            this.isDeathmatch = false;
        } else if (currentState.equals((Object)SurvivalGameRunningState.IN_PROGRESS)) {
            newState = SurvivalGameRunningState.IN_PROGRESS;
            this.isDeathmatch = false;
        } else if (currentState.equals((Object)SurvivalGameRunningState.DEATH_MATCH)) {
            newState = SurvivalGameRunningState.DEATH_MATCH;
            this.isDeathmatch = true;
        }
        this.borderIndex = 0;
        this.savedRunningState = newState;
    }

    @Override
    public void run() {
        while (this.shouldRun) {
            try {
                SurvivalGameRunningState currentRunning;
                SurvivalGameState current = this.survivalGame.getState();
                if (current != this.savedState) {
                    this.setState(current);
                }
                if ((currentRunning = this.survivalGame.getRunningState()) != this.savedRunningState) {
                    this.setRunningState(currentRunning);
                }
                Optional.ofNullable(this.stateFunctions.get((Object)this.state)).ifPresent(Runnable::run);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
                break;
            }
        }
    }

    void cancel() {
        this.shouldRun = false;
    }

    private void stopped() {
        this.toState(ScheduleState.LOBBY, () -> SurvivalGameStateManager.ready(this.survivalGame), (Text)Text.of((String)"Readying game"));
    }

    private void lobby() {
        if (this.survivalGame.getPlayerCount() == 0) {
            this.startTime = null;
            return;
        }
        if (this.startTime == null) {
            this.startTime = Instant.now();
        }
        if (this.schedule.getLobbyTimeLimit().isPresent()) {
            Duration lobbyTimeLimit;
            Instant change;
            Instant now = Instant.now();
            if (now.isAfter(change = this.startTime.plus(lobbyTimeLimit = this.schedule.getLobbyTimeLimit().get()))) {
                this.toState(ScheduleState.LOBBY_COUNTDOWN, null, null);
            }
        } else if (this.schedule.getMinimumPlayerCount().isPresent()) {
            Integer minPlayerCount = this.schedule.getMinimumPlayerCount().get();
            if (this.survivalGame.getPlayerCount() > minPlayerCount) {
                this.toState(ScheduleState.LOBBY_COUNTDOWN, null, null);
            }
        } else {
            this.toState(ScheduleState.LOBBY_COUNTDOWN, null, null);
        }
    }

    private void lobbyCountdown() {
        Runnable start = () -> {
            SurvivalGameStateManager.start(this.survivalGame);
            this.borderIndex = 0;
        };
        if (this.startTime == null) {
            this.startTime = Instant.now();
        }
        if (this.schedule.getLobbyCountdown().isPresent()) {
            Duration lobbyCountDown;
            Instant change;
            Instant now = Instant.now();
            if (now.isAfter(change = this.startTime.plus(lobbyCountDown = this.schedule.getLobbyCountdown().get()))) {
                this.toState(ScheduleState.RUNNING, start, (Text)Text.of((String)"Starting game"));
            } else {
                this.survivalGame.sendMessage(Text.of((Object[])new Object[]{"Game starts in ", lobbyCountDown.minus(Duration.between(this.startTime, now)).getSeconds(), " seconds"}));
            }
        } else {
            this.toState(ScheduleState.RUNNING, start, (Text)Text.of((String)"Starting game"));
        }
    }

    private void running() {
        Instant change;
        List<WorldBorderStage> stages;
        if (this.survivalGame.getState().equals((Object)SurvivalGameState.STOPPED)) {
            this.toState(ScheduleState.STOPPED, null, null);
            return;
        }
        if (this.startTime == null) {
            this.startTime = Instant.now();
        }
        if ((stages = this.isDeathmatch ? this.schedule.getDeathMatchStages() : this.schedule.getWorldBorderStages()).size() <= this.borderIndex) {
            return;
        }
        WorldBorderStage stage = stages.get(this.borderIndex);
        Instant now = Instant.now();
        if (now.isAfter(change = this.startTime.plus(stage.getWaitTime()))) {
            String worldName = this.survivalGame.getConfig().getWorldName().orElseThrow(() -> new RuntimeException("world-name"));
            World world = (World)Sponge.getServer().getWorld(worldName).orElseThrow(() -> new RuntimeException("world"));
            WorldBorder wb = world.getWorldBorder();
            double newDiameter = Double.max(wb.getDiameter() - (double)stage.getDiameterDelta(), 0.0);
            wb.setDiameter(newDiameter, stage.getMovementTime().toMillis());
            ++this.borderIndex;
            this.startTime = null;
            this.survivalGame.sendMessage((Text)Text.of((String)"The border is starting to shrink..."));
        }
    }

    private void toState(ScheduleState targetState, Runnable setState, Text message) {
        SurvivalGamesPlugin.SYNC_EXECUTOR.submit(() -> {
            if (message != null) {
                this.survivalGame.sendMessage(message);
            }
            if (setState != null) {
                setState.run();
            }
            this.startTime = null;
            this.state = targetState;
        });
    }

    private static enum ScheduleState {
        STOPPED,
        LOBBY,
        LOBBY_COUNTDOWN,
        RUNNING;

    }
}

