/*
 * Decompiled with CFR 0.152.
 */
package io.github.m0pt0pmatt.survivalgames.scoreboard;

import com.google.common.base.Preconditions;
import io.github.m0pt0pmatt.survivalgames.game.SurvivalGame;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import org.spongepowered.api.scoreboard.Scoreboard;

public final class ScoreboardRepository {
    private static final Map<SurvivalGame, Scoreboard> MAP = new ConcurrentHashMap<SurvivalGame, Scoreboard>();

    private ScoreboardRepository() {
    }

    public static void put(SurvivalGame survivalGame, Scoreboard scoreboard) {
        Preconditions.checkNotNull((Object)survivalGame, (Object)"survivalGame");
        MAP.put(survivalGame, scoreboard);
    }

    public static Optional<Scoreboard> get(SurvivalGame survivalGame) {
        return Optional.ofNullable(MAP.get(survivalGame));
    }

    public static Optional<Scoreboard> remove(SurvivalGame survivalGame) {
        return Optional.ofNullable(MAP.remove(survivalGame));
    }
}

