/*
 * Decompiled with CFR 0.152.
 */
package io.github.m0pt0pmatt.survivalgames.task;

import io.github.m0pt0pmatt.survivalgames.Util;
import io.github.m0pt0pmatt.survivalgames.command.CommandKeys;
import io.github.m0pt0pmatt.survivalgames.game.SurvivalGame;
import io.github.m0pt0pmatt.survivalgames.task.Task;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.entity.Entity;
import org.spongepowered.api.entity.living.player.Player;
import org.spongepowered.api.util.TextMessageException;
import org.spongepowered.api.world.World;

public class ClearEntitiesTask
implements Task {
    private static ClearEntitiesTask INSTANCE = new ClearEntitiesTask();

    private ClearEntitiesTask() {
    }

    @Override
    public void execute(SurvivalGame survivalGame) throws TextMessageException {
        String worldName = Util.getOrThrow(survivalGame.getConfig().getWorldName(), (Object)CommandKeys.WORLD_NAME);
        World world = (World)Util.getOrThrow(Sponge.getServer().getWorld(worldName), (Object)CommandKeys.WORLD_NAME);
        world.getEntities().stream().filter(e -> !(e instanceof Player)).forEach(Entity::remove);
    }

    public static ClearEntitiesTask getInstance() {
        return INSTANCE;
    }
}

