/*
 * Decompiled with CFR 0.152.
 */
package io.github.m0pt0pmatt.survivalgames.task;

import com.flowpowered.math.vector.Vector3d;
import com.google.common.collect.ImmutableSet;
import io.github.m0pt0pmatt.survivalgames.SurvivalGamesPlugin;
import io.github.m0pt0pmatt.survivalgames.game.SurvivalGame;
import io.github.m0pt0pmatt.survivalgames.task.Task;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.block.BlockType;
import org.spongepowered.api.block.BlockTypes;
import org.spongepowered.api.util.TextMessageException;
import org.spongepowered.api.world.BlockChangeFlags;
import org.spongepowered.api.world.World;

public class CreateCageSnapshotsTask
implements Task {
    private static final Task INSTANCE = new CreateCageSnapshotsTask();
    private static final Set<Vector3d> SURROUNDING_BLOCKS = ImmutableSet.builder().add((Object)new Vector3d(1.0f, 0.0f, 0.0f)).add((Object)new Vector3d(1.0f, 1.0f, 0.0f)).add((Object)new Vector3d(-1.0f, 0.0f, 0.0f)).add((Object)new Vector3d(-1.0f, 1.0f, 0.0f)).add((Object)new Vector3d(0.0f, 0.0f, 1.0f)).add((Object)new Vector3d(0.0f, 1.0f, 1.0f)).add((Object)new Vector3d(0.0f, 0.0f, -1.0f)).add((Object)new Vector3d(0.0f, 1.0f, -1.0f)).add((Object)new Vector3d(0.0f, 2.0f, 0.0f)).build();

    @Override
    public void execute(SurvivalGame survivalGame) throws TextMessageException {
        this.setBlocks(survivalGame, BlockTypes.BARRIER);
        int countdownSeconds = survivalGame.getConfig().getCountdownSeconds().orElse(10);
        SurvivalGamesPlugin.SYNC_EXECUTOR.schedule(() -> this.setBlocks(survivalGame, BlockTypes.AIR), (long)countdownSeconds, TimeUnit.SECONDS);
    }

    private void setBlocks(SurvivalGame survivalGame, BlockType blockType) {
        Optional<String> worldName = survivalGame.getConfig().getWorldName();
        if (!worldName.isPresent()) {
            return;
        }
        Optional world = Sponge.getServer().getWorld(worldName.get());
        if (!world.isPresent()) {
            return;
        }
        survivalGame.getConfig().getSpawnPoints().forEach(spawnPoint -> SURROUNDING_BLOCKS.forEach(vector3i -> ((World)world.get()).getLocation(spawnPoint.add(vector3i)).setBlockType(blockType, BlockChangeFlags.ALL)));
    }

    public static Task getInstance() {
        return INSTANCE;
    }
}

