/*
 * Decompiled with CFR 0.152.
 */
package io.github.m0pt0pmatt.survivalgames.task;

import com.flowpowered.math.vector.Vector3d;
import io.github.m0pt0pmatt.survivalgames.Util;
import io.github.m0pt0pmatt.survivalgames.command.CommandKeys;
import io.github.m0pt0pmatt.survivalgames.game.SurvivalGame;
import io.github.m0pt0pmatt.survivalgames.task.Task;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.util.TextMessageException;
import org.spongepowered.api.world.World;
import org.spongepowered.api.world.WorldBorder;

public class CreateDeathmatchBorderTask
implements Task {
    private static final Task INSTANCE = new CreateDeathmatchBorderTask();

    @Override
    public void execute(SurvivalGame survivalGame) throws TextMessageException {
        Integer xMin = null;
        Integer xMax = null;
        Integer zMin = null;
        Integer zMax = null;
        for (Vector3d spawn : survivalGame.getConfig().getSpawnPoints()) {
            xMin = xMin == null ? Integer.valueOf(spawn.getFloorX()) : Integer.valueOf(Math.min(xMin, spawn.getFloorX()));
            xMax = xMax == null ? Integer.valueOf(spawn.getFloorX()) : Integer.valueOf(Math.max(xMax, spawn.getFloorX()));
            zMin = zMin == null ? Integer.valueOf(spawn.getFloorZ()) : Integer.valueOf(Math.min(zMin, spawn.getFloorZ()));
            if (zMax == null) {
                zMax = spawn.getFloorZ();
                continue;
            }
            zMax = Math.max(zMax, spawn.getFloorZ());
        }
        if (xMin != null) {
            String worldName = Util.getOrThrow(survivalGame.getConfig().getWorldName(), (Object)CommandKeys.WORLD_NAME);
            World world = (World)Util.getOrThrow(Sponge.getServer().getWorld(worldName), (Object)CommandKeys.WORLD);
            WorldBorder worldBorder = world.getWorldBorder();
            double diameter = Double.max(Math.abs(xMax - xMin), Math.abs(zMax - zMin));
            double xMiddle = (double)xMin.intValue() + diameter / 2.0;
            double zMiddle = (double)zMin.intValue() + diameter / 2.0;
            worldBorder.setCenter(xMiddle, zMiddle);
            worldBorder.setDiameter(Double.max(Math.abs(xMax - xMin), Math.abs(zMax - zMin)) + 5.0);
            worldBorder.setWarningDistance(5);
            worldBorder.setDamageThreshold(0.0);
        }
    }

    public static Task getInstance() {
        return INSTANCE;
    }
}

