/*
 * Decompiled with CFR 0.152.
 */
package io.github.m0pt0pmatt.survivalgames.task;

import com.flowpowered.math.vector.Vector3d;
import io.github.m0pt0pmatt.survivalgames.Util;
import io.github.m0pt0pmatt.survivalgames.command.CommandKeys;
import io.github.m0pt0pmatt.survivalgames.game.SurvivalGame;
import io.github.m0pt0pmatt.survivalgames.task.Task;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.util.TextMessageException;
import org.spongepowered.api.world.World;
import org.spongepowered.api.world.WorldBorder;

public class CreateWorldBorderTask
implements Task {
    private static final Task INSTANCE = new CreateWorldBorderTask();

    @Override
    public void execute(SurvivalGame survivalGame) throws TextMessageException {
        String worldName = Util.getOrThrow(survivalGame.getConfig().getWorldName(), (Object)CommandKeys.WORLD_NAME);
        World world = (World)Util.getOrThrow(Sponge.getServer().getWorld(worldName), (Object)CommandKeys.WORLD);
        WorldBorder worldBorder = world.getWorldBorder();
        Vector3d center = Util.getOrThrow(survivalGame.getConfig().getCenterVector(), (Object)CommandKeys.CENTER_VECTOR);
        worldBorder.setCenter(center.getX(), center.getZ());
        Vector3d lesserBoundaryVector = Util.getOrThrow(survivalGame.getConfig().getBlockArea().getLesserBoundary(), (Object)CommandKeys.LESSER_BOUNDARY);
        Vector3d greaterBoundaryVector = Util.getOrThrow(survivalGame.getConfig().getBlockArea().getGreaterBoundary(), (Object)CommandKeys.GREATER_BOUNDARY);
        double diameter = Double.max(Math.abs(greaterBoundaryVector.getX() - lesserBoundaryVector.getX()), Math.abs(greaterBoundaryVector.getZ() - lesserBoundaryVector.getZ()));
        double xMiddle = lesserBoundaryVector.getX() + diameter / 2.0;
        double zMiddle = lesserBoundaryVector.getZ() + diameter / 2.0;
        worldBorder.setCenter(xMiddle, zMiddle);
        worldBorder.setDiameter(diameter);
        worldBorder.setWarningDistance(5);
        worldBorder.setDamageThreshold(0.0);
    }

    public static Task getInstance() {
        return INSTANCE;
    }
}

