/*
 * Decompiled with CFR 0.152.
 */
package io.github.m0pt0pmatt.survivalgames.task;

import io.github.m0pt0pmatt.survivalgames.Util;
import io.github.m0pt0pmatt.survivalgames.command.CommandKeys;
import io.github.m0pt0pmatt.survivalgames.game.SurvivalGame;
import io.github.m0pt0pmatt.survivalgames.task.Task;
import java.util.Random;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.block.tileentity.carrier.Chest;
import org.spongepowered.api.item.inventory.ItemStackSnapshot;
import org.spongepowered.api.util.TextMessageException;
import org.spongepowered.api.world.World;

public class FillChestsTask
implements Task {
    private static final Task INSTANCE = new FillChestsTask();
    private static final Random RANDOM = new Random();

    @Override
    public void execute(SurvivalGame survivalGame) throws TextMessageException {
        String worldName = Util.getOrThrow(survivalGame.getConfig().getWorldName(), (Object)CommandKeys.WORLD_NAME);
        World world = (World)Util.getOrThrow(Sponge.getServer().getWorld(worldName), (Object)CommandKeys.WORLD_NAME);
        Integer chestMidpoint = Util.getOrThrow(survivalGame.getConfig().getChestMidpoint(), (Object)CommandKeys.CHEST_MIDPOINT);
        Integer chestRange = Util.getOrThrow(survivalGame.getConfig().getChestRange(), (Object)CommandKeys.CHEST_RANGE);
        world.getTileEntities().forEach(tileEntity -> {
            if (tileEntity instanceof Chest) {
                Chest chest = (Chest)tileEntity;
                chest.getInventory().clear();
                if (!survivalGame.getConfig().getItemConfig().getItems().isEmpty()) {
                    double itemCount = (double)chestMidpoint.intValue() + RANDOM.nextDouble() * (double)chestRange.intValue() * (double)(RANDOM.nextDouble() > 0.5 ? 1 : -1);
                    int i = 0;
                    while ((double)i < itemCount) {
                        ItemStackSnapshot stackSnapshot = survivalGame.getConfig().getItemConfig().getItems().get(RANDOM.nextInt(survivalGame.getConfig().getItemConfig().getItems().size()));
                        chest.getInventory().offer(stackSnapshot.createStack());
                        ++i;
                    }
                }
            }
        });
    }

    public static Task getInstance() {
        return INSTANCE;
    }
}

