/*
 * Decompiled with CFR 0.152.
 */
package io.github.m0pt0pmatt.survivalgames.task;

import io.github.m0pt0pmatt.survivalgames.Util;
import io.github.m0pt0pmatt.survivalgames.command.CommandKeys;
import io.github.m0pt0pmatt.survivalgames.game.SurvivalGame;
import io.github.m0pt0pmatt.survivalgames.task.Task;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.util.TextMessageException;
import org.spongepowered.api.world.World;

public class LoadChunksTask
implements Task {
    private static LoadChunksTask INSTANCE = new LoadChunksTask();

    private LoadChunksTask() {
    }

    @Override
    public void execute(SurvivalGame survivalGame) throws TextMessageException {
        String worldName = Util.getOrThrow(survivalGame.getConfig().getWorldName(), (Object)CommandKeys.WORLD_NAME);
        World world = (World)Util.getOrThrow(Sponge.getServer().getWorld(worldName), (Object)CommandKeys.WORLD_NAME);
        int maxX = world.getLocation(survivalGame.getConfig().getBlockArea().getGreaterBoundary().get()).getChunkPosition().getX();
        int minZ = world.getLocation(survivalGame.getConfig().getBlockArea().getLesserBoundary().get()).getChunkPosition().getZ();
        int maxZ = world.getLocation(survivalGame.getConfig().getBlockArea().getGreaterBoundary().get()).getChunkPosition().getZ();
        for (int minX = world.getLocation(survivalGame.getConfig().getBlockArea().getLesserBoundary().get()).getChunkPosition().getX(); minX <= maxX; ++minX) {
            for (int z = minZ; z <= maxZ; ++z) {
                world.loadChunk(minX, 0, z, false);
            }
        }
    }

    public static LoadChunksTask getInstance() {
        return INSTANCE;
    }
}

