/*
 * Decompiled with CFR 0.152.
 */
package io.github.m0pt0pmatt.survivalgames.task;

import io.github.m0pt0pmatt.survivalgames.Util;
import io.github.m0pt0pmatt.survivalgames.command.CommandKeys;
import io.github.m0pt0pmatt.survivalgames.data.MobSpawnArea;
import io.github.m0pt0pmatt.survivalgames.game.SurvivalGame;
import io.github.m0pt0pmatt.survivalgames.mobspawn.ActiveMobSpawnRepository;
import io.github.m0pt0pmatt.survivalgames.task.Task;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.util.TextMessageException;
import org.spongepowered.api.world.World;

public class StartMobSpawnersTask
implements Task {
    private static final Task INSTANCE = new StartMobSpawnersTask();

    private StartMobSpawnersTask() {
    }

    @Override
    public void execute(SurvivalGame survivalGame) throws TextMessageException {
        String worldName = Util.getOrThrow(survivalGame.getConfig().getWorldName(), (Object)CommandKeys.WORLD_NAME);
        World world = (World)Util.getOrThrow(Sponge.getServer().getWorld(worldName), (Object)CommandKeys.WORLD);
        for (MobSpawnArea mobSpawnArea : survivalGame.getConfig().getMobSpawnAreas()) {
            survivalGame.getActiveMobSpawners().add(ActiveMobSpawnRepository.start(survivalGame, mobSpawnArea, world));
        }
    }

    public static Task getInstance() {
        return INSTANCE;
    }
}

