/*
 * Decompiled with CFR 0.152.
 */
package io.github.m0pt0pmatt.survivalgames.task.player;

import com.google.common.collect.ImmutableMap;
import io.github.m0pt0pmatt.survivalgames.SurvivalGamesPlugin;
import io.github.m0pt0pmatt.survivalgames.Util;
import io.github.m0pt0pmatt.survivalgames.command.CommandKeys;
import io.github.m0pt0pmatt.survivalgames.event.DeathmatchPostCountdownEvent;
import io.github.m0pt0pmatt.survivalgames.event.DeathmatchPreCountdownEvent;
import io.github.m0pt0pmatt.survivalgames.event.GameStartedPostCountdownEvent;
import io.github.m0pt0pmatt.survivalgames.event.GameStartedPreCountdownEvent;
import io.github.m0pt0pmatt.survivalgames.event.PostCountdownEvent;
import io.github.m0pt0pmatt.survivalgames.event.PreCountdownEvent;
import io.github.m0pt0pmatt.survivalgames.game.SurvivalGame;
import io.github.m0pt0pmatt.survivalgames.game.SurvivalGameRunningState;
import io.github.m0pt0pmatt.survivalgames.task.player.PlayerAndSpectatorTask;
import java.util.ArrayList;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.entity.living.player.Player;
import org.spongepowered.api.event.Event;
import org.spongepowered.api.text.Text;
import org.spongepowered.api.text.format.TextColors;
import org.spongepowered.api.text.title.Title;
import org.spongepowered.api.util.TextMessageException;

public class CreateCountdownTask
extends PlayerAndSpectatorTask {
    private static final Map<SurvivalGameRunningState, Function<SurvivalGame, PostCountdownEvent>> postEvents = ImmutableMap.builder().put((Object)SurvivalGameRunningState.STOPPED, GameStartedPostCountdownEvent::new).put((Object)SurvivalGameRunningState.IN_PROGRESS, DeathmatchPostCountdownEvent::new).build();
    private static final Map<SurvivalGameRunningState, Function<SurvivalGame, PreCountdownEvent>> preEvents = ImmutableMap.builder().put((Object)SurvivalGameRunningState.STOPPED, GameStartedPreCountdownEvent::new).put((Object)SurvivalGameRunningState.IN_PROGRESS, DeathmatchPreCountdownEvent::new).build();
    private static final Map<SurvivalGameRunningState, Text> text = ImmutableMap.builder().put((Object)SurvivalGameRunningState.STOPPED, (Object)Text.of((String)"Game")).put((Object)SurvivalGameRunningState.IN_PROGRESS, (Object)Text.of((String)"Deathmatch")).build();

    private CreateCountdownTask() {
    }

    @Override
    public void execute(SurvivalGame survivalGame, Player player) throws TextMessageException {
        int i;
        int countDown = Util.getOrThrow(survivalGame.getConfig().getCountdownSeconds(), (Object)CommandKeys.COUNT_DOWN_SECONDS);
        ArrayList<Title> titles = new ArrayList<Title>();
        Text title = Optional.ofNullable(text.get((Object)survivalGame.getRunningState())).orElse((Text)Text.of((String)"Game"));
        for (i = 0; i < countDown + 1; ++i) {
            titles.add(Title.builder().fadeIn(Integer.valueOf(5)).stay(Integer.valueOf(20)).fadeOut(Integer.valueOf(5)).title(Text.of((Object[])new Object[]{TextColors.RED, title, " begins in..."})).subtitle(Text.of((Object[])new Object[]{TextColors.RED, countDown - i})).build());
        }
        for (i = 0; i < countDown + 1; ++i) {
            int j = i;
            SurvivalGamesPlugin.SYNC_EXECUTOR.schedule(() -> player.sendTitle((Title)titles.get(j)), (long)i, TimeUnit.SECONDS);
        }
        Optional.ofNullable(preEvents.get((Object)survivalGame.getRunningState())).map(f -> (PreCountdownEvent)((Object)((Object)f.apply(survivalGame)))).ifPresent(e -> Sponge.getEventManager().post((Event)e));
        Optional.ofNullable(postEvents.get((Object)survivalGame.getRunningState())).map(f -> (PostCountdownEvent)((Object)((Object)f.apply(survivalGame)))).ifPresent(e -> SurvivalGamesPlugin.SYNC_EXECUTOR.schedule(() -> Sponge.getEventManager().post((Event)e), (long)countDown, TimeUnit.SECONDS));
    }

    public static CreateCountdownTask getInstance() {
        return new CreateCountdownTask();
    }
}

