/*
 * Decompiled with CFR 0.152.
 */
package io.github.m0pt0pmatt.survivalgames.task.player;

import com.flowpowered.math.vector.Vector3d;
import io.github.m0pt0pmatt.survivalgames.Util;
import io.github.m0pt0pmatt.survivalgames.command.CommandKeys;
import io.github.m0pt0pmatt.survivalgames.game.PlayerRestorer;
import io.github.m0pt0pmatt.survivalgames.game.SurvivalGame;
import io.github.m0pt0pmatt.survivalgames.task.player.AbstractPlayerTask;
import io.github.m0pt0pmatt.survivalgames.task.player.SpectatorTask;
import java.util.ArrayList;
import java.util.List;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.data.key.Keys;
import org.spongepowered.api.entity.living.player.Player;
import org.spongepowered.api.entity.living.player.gamemode.GameModes;
import org.spongepowered.api.util.TextMessageException;
import org.spongepowered.api.world.World;

public class SpawnSpectatorsTask
extends SpectatorTask {
    private static final AbstractPlayerTask INSTANCE = new SpawnSpectatorsTask();
    private List<Vector3d> spawnPoints;
    private Vector3d centerVector;

    @Override
    public void execute(SurvivalGame survivalGame, Player player) throws TextMessageException {
        String worldName = Util.getOrThrow(survivalGame.getConfig().getWorldName(), (Object)CommandKeys.WORLD_NAME);
        World world = (World)Util.getOrThrow(Sponge.getServer().getWorld(worldName), (Object)CommandKeys.WORLD);
        if (!this.spawnPoints.isEmpty()) {
            Vector3d spawnPoint = this.spawnPoints.remove(0);
            SpawnSpectatorsTask.spawnPlayer(survivalGame, player, world, new Vector3d(spawnPoint.getX(), spawnPoint.getY(), spawnPoint.getZ()), new Vector3d(this.centerVector.getX(), this.centerVector.getY(), this.centerVector.getZ()));
        }
    }

    private static void spawnPlayer(SurvivalGame survivalGame, Player player, World world, Vector3d spawnPoint, Vector3d centerVector) {
        survivalGame.getPlayerSnapshots().put(player.getUniqueId(), new PlayerRestorer(player));
        player.setLocation(world.getLocation(spawnPoint).add(new Vector3d(0.5, 10.0, 0.5)));
        player.lookAt(centerVector);
        player.offer(Keys.GAME_MODE, (Object)GameModes.SPECTATOR);
    }

    @Override
    protected void before(SurvivalGame survivalGame) throws TextMessageException {
        this.spawnPoints = new ArrayList<Vector3d>(survivalGame.getConfig().getSpawnPoints());
        this.centerVector = Util.getOrThrow(survivalGame.getConfig().getCenterVector(), (Object)CommandKeys.CENTER_VECTOR);
    }

    public static AbstractPlayerTask getInstance() {
        return INSTANCE;
    }
}

