/*
 * Decompiled with CFR 0.152.
 */
package io.github.m0pt0pmatt.survivalgames.thread;

import com.google.common.base.Preconditions;
import io.github.m0pt0pmatt.survivalgames.thread.DotProgressable;
import io.github.m0pt0pmatt.survivalgames.thread.Progressable;
import io.github.m0pt0pmatt.survivalgames.thread.WatcherRunnable;
import java.time.temporal.TemporalAmount;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.Executor;
import java.util.function.Consumer;
import org.spongepowered.api.command.CommandSource;
import org.spongepowered.api.text.Text;
import org.spongepowered.api.text.channel.MessageChannel;
import org.spongepowered.api.text.channel.MessageReceiver;

public class ProgressBuilder {
    private final MessageChannel messageChannel;
    private final Executor syncExecutor;
    private final Executor asyncExecutor;
    private final List<WatcherRunnable> tasks = new ArrayList<WatcherRunnable>();
    private boolean error = false;

    private ProgressBuilder(MessageChannel messageChannel, Executor syncExecutor, Executor asyncExecutor) {
        this.messageChannel = (MessageChannel)Preconditions.checkNotNull((Object)messageChannel, (Object)"messageReceiver");
        this.syncExecutor = (Executor)Preconditions.checkNotNull((Object)syncExecutor, (Object)"syncExecutor");
        this.asyncExecutor = (Executor)Preconditions.checkNotNull((Object)asyncExecutor, (Object)"asyncExecutor");
    }

    public ProgressBuilder runSync(Progressable progressable, String name, TemporalAmount timeout) {
        Preconditions.checkNotNull((Object)progressable, (Object)"progressable");
        WatcherRunnable watcher = new WatcherRunnable(progressable, name, timeout, this.messageChannel, this.syncExecutor);
        this.tasks.add(watcher);
        return this;
    }

    public ProgressBuilder runSync(Runnable runnable, String name, TemporalAmount timeout) {
        Preconditions.checkNotNull((Object)runnable, (Object)"runnable");
        WatcherRunnable watcher = new WatcherRunnable(new DotProgressable(runnable), name, timeout, this.messageChannel, this.syncExecutor);
        this.tasks.add(watcher);
        return this;
    }

    public ProgressBuilder runSync(Consumer<MessageChannel> consumer, String name, TemporalAmount timeout) {
        Preconditions.checkNotNull(consumer, (Object)"consumer");
        WatcherRunnable watcher = new WatcherRunnable(new DotProgressable(() -> consumer.accept(this.messageChannel)), name, timeout, this.messageChannel, this.syncExecutor);
        this.tasks.add(watcher);
        return this;
    }

    public ProgressBuilder runAsync(Progressable progressable, String name, TemporalAmount timeout) {
        Preconditions.checkNotNull((Object)progressable, (Object)"progressable");
        WatcherRunnable watcher = new WatcherRunnable(progressable, name, timeout, this.messageChannel, this.asyncExecutor);
        this.tasks.add(watcher);
        return this;
    }

    public ProgressBuilder runAsync(Runnable runnable, String name, TemporalAmount timeout) {
        Preconditions.checkNotNull((Object)runnable, (Object)"runnable");
        WatcherRunnable watcher = new WatcherRunnable(new DotProgressable(runnable), name, timeout, this.messageChannel, this.asyncExecutor);
        this.tasks.add(watcher);
        return this;
    }

    public ProgressBuilder runAsync(Consumer<MessageChannel> consumer, String name, TemporalAmount timeout) {
        Preconditions.checkNotNull(consumer, (Object)"consumer");
        WatcherRunnable watcher = new WatcherRunnable(new DotProgressable(() -> consumer.accept(this.messageChannel)), name, timeout, this.messageChannel, this.asyncExecutor);
        this.tasks.add(watcher);
        return this;
    }

    public CompletableFuture<Void> start() {
        CompletionStage<Void> future = null;
        for (WatcherRunnable task : this.tasks) {
            if (future == null) {
                future = CompletableFuture.runAsync(this.handleException(task), this.asyncExecutor);
                continue;
            }
            future = future.thenRunAsync(this.handleException(task), this.asyncExecutor);
        }
        return future;
    }

    private Runnable handleException(Runnable runnable) {
        return () -> {
            if (!this.error) {
                try {
                    runnable.run();
                }
                catch (Throwable throwable) {
                    this.messageChannel.send((Text)Text.of((String)"Error running command. Check the server logs for more details"));
                    Optional.ofNullable(throwable.getCause()).ifPresent(Throwable::printStackTrace);
                    this.error = true;
                }
            }
        };
    }

    public static ProgressBuilder builder(MessageChannel messageChannel, Executor syncExecutor, Executor asyncExecutor) {
        return new ProgressBuilder(messageChannel, syncExecutor, asyncExecutor);
    }

    public static ProgressBuilder builder(CommandSource commandSource, Executor syncExecutor, Executor asyncExecutor) {
        return new ProgressBuilder(MessageChannel.fixed((MessageReceiver[])new MessageReceiver[]{commandSource}), syncExecutor, asyncExecutor);
    }
}

