/*
 * Decompiled with CFR 0.152.
 */
package io.github.m0pt0pmatt.survivalgames.thread;

import io.github.m0pt0pmatt.survivalgames.SurvivalGamesPlugin;
import io.github.m0pt0pmatt.survivalgames.game.SurvivalGame;
import io.github.m0pt0pmatt.survivalgames.thread.PercentageProgressable;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import org.spongepowered.api.block.BlockSnapshot;
import org.spongepowered.api.world.BlockChangeFlags;

public class ResetBlocksProgressable
extends PercentageProgressable {
    private final SurvivalGame survivalGame;

    public ResetBlocksProgressable(SurvivalGame survivalGame) {
        this.survivalGame = survivalGame;
    }

    @Override
    public void run() {
        int chunkCount = 50000;
        int total = this.survivalGame.getConfig().getBlocks().size();
        Iterator<BlockSnapshot> iterator = this.survivalGame.getConfig().getBlocks().iterator();
        for (int i = 0; i < total; i += chunkCount) {
            block6: {
                int start = i;
                Future future = SurvivalGamesPlugin.SYNC_EXECUTOR.submit(() -> {
                    for (int j = start; j < start + chunkCount; ++j) {
                        BlockSnapshot blockSnapshot = (BlockSnapshot)iterator.next();
                        blockSnapshot.restore(true, BlockChangeFlags.ALL);
                    }
                });
                try {
                    future.get();
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                    return;
                }
                catch (ExecutionException e) {
                    if (e.getCause() instanceof NoSuchElementException) break block6;
                    e.printStackTrace();
                    return;
                }
            }
            this.setPercentage((double)i / (double)total);
            try {
                Thread.sleep(100L);
                continue;
            }
            catch (InterruptedException e) {
                e.printStackTrace();
                return;
            }
        }
    }
}

