/*
 * Decompiled with CFR 0.152.
 */
package io.github.m0pt0pmatt.survivalgames.thread;

import com.flowpowered.math.vector.Vector3d;
import com.google.common.collect.Lists;
import io.github.m0pt0pmatt.survivalgames.game.SurvivalGame;
import io.github.m0pt0pmatt.survivalgames.thread.PercentageProgressable;
import java.util.ArrayList;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.world.World;

public class SetBlocksProgressable
extends PercentageProgressable {
    private final SurvivalGame survivalGame;

    public SetBlocksProgressable(SurvivalGame survivalGame) {
        this.survivalGame = survivalGame;
    }

    @Override
    public void run() {
        this.setBlocks();
    }

    private void setBlocks() {
        Vector3d lesser = this.survivalGame.getConfig().getBlockArea().getLesserBoundary().orElseThrow(() -> new IllegalStateException("Missing boundaries"));
        Vector3d greater = this.survivalGame.getConfig().getBlockArea().getGreaterBoundary().orElseThrow(() -> new IllegalStateException("Missing boundaries"));
        ArrayList blocks = Lists.newArrayList();
        World world = (World)this.survivalGame.getConfig().getWorldName().flatMap(n -> Sponge.getServer().getWorld(n)).orElseThrow(() -> new IllegalStateException("No world yet"));
        long totalBlocks = (greater.getFloorX() - lesser.getFloorX()) * (greater.getFloorY() - lesser.getFloorY()) * (greater.getFloorZ() - lesser.getFloorZ());
        long count = 0L;
        for (int x = lesser.getFloorX(); x < greater.getFloorX(); ++x) {
            for (int y = lesser.getFloorY(); y < greater.getFloorY(); ++y) {
                for (int z = lesser.getFloorZ(); z < greater.getFloorZ(); ++z) {
                    blocks.add(world.createSnapshot(x, y, z));
                    ++count;
                    if (totalBlocks == 0L) continue;
                    this.setPercentage((double)count / (double)totalBlocks);
                }
            }
        }
        this.survivalGame.getConfig().setBlocks(blocks);
    }
}

