/*
 * Decompiled with CFR 0.152.
 */
package io.github.m0pt0pmatt.survivalgames.thread;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;

public class UnzipRunnable
implements Runnable {
    private final String fileName;
    private final String path;
    private static final int BUFFER_SIZE = 4096;

    public UnzipRunnable(String fileName, String path) {
        this.fileName = fileName;
        this.path = path;
    }

    @Override
    public void run() {
        try {
            File destDir = new File(this.path);
            byte[] buffer = new byte[4096];
            ZipInputStream zis = new ZipInputStream(new FileInputStream(this.fileName));
            ZipEntry zipEntry = zis.getNextEntry();
            while (zipEntry != null) {
                File newFile = UnzipRunnable.newFile(destDir, zipEntry);
                if (zipEntry.isDirectory()) {
                    if (!newFile.mkdir()) {
                        throw new RuntimeException("Unable to create directory " + newFile.getAbsolutePath());
                    }
                } else {
                    int len;
                    FileOutputStream fos = new FileOutputStream(newFile);
                    while ((len = zis.read(buffer)) > 0) {
                        fos.write(buffer, 0, len);
                    }
                    fos.close();
                }
                zipEntry = zis.getNextEntry();
            }
            zis.closeEntry();
            zis.close();
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException("Unable to unzip world", e);
        }
    }

    private static File newFile(File destinationDir, ZipEntry zipEntry) throws IOException {
        File destFile = new File(destinationDir, zipEntry.getName());
        String destDirPath = destinationDir.getCanonicalPath();
        String destFilePath = destFile.getCanonicalPath();
        if (!destFilePath.startsWith(destDirPath + File.separator)) {
            throw new IOException("Entry is outside of the target dir: " + zipEntry.getName());
        }
        return destFile;
    }
}

