/*
 * Decompiled with CFR 0.152.
 */
package io.github.m0pt0pmatt.survivalgames.thread;

import com.google.common.base.Preconditions;
import io.github.m0pt0pmatt.survivalgames.thread.PercentageProgressable;
import io.github.m0pt0pmatt.survivalgames.thread.Progressable;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.net.URL;

public class UrlDownloadRunnable
extends PercentageProgressable
implements Runnable,
Progressable {
    private final URL url;
    private final String fileName;
    private final long expectedFileSize;

    public UrlDownloadRunnable(URL url, String fileName, long expectedFileSize) {
        this.url = (URL)Preconditions.checkNotNull((Object)url, (Object)"url");
        this.fileName = (String)Preconditions.checkNotNull((Object)fileName, (Object)"fileName");
        this.expectedFileSize = expectedFileSize;
    }

    public UrlDownloadRunnable(URL url, String fileName) {
        this(url, fileName, 0L);
    }

    @Override
    public void run() {
        int count = 0;
        int limit = 4096;
        byte[] byteBuffer = new byte[limit];
        try {
            int c;
            InputStream inputStream = this.url.openStream();
            FileOutputStream fos = new FileOutputStream(this.fileName);
            while ((c = inputStream.read(byteBuffer)) >= 0) {
                fos.write(byteBuffer, 0, c);
                count += c;
                if (this.expectedFileSize == 0L) continue;
                this.setPercentage((double)count / (double)this.expectedFileSize);
            }
            inputStream.close();
            fos.close();
        }
        catch (Exception e) {
            throw new RuntimeException("Unable to download URL", e);
        }
        finally {
            this.setPercentage(1.0);
        }
    }
}

