/*
 * Decompiled with CFR 0.152.
 */
package io.github.m0pt0pmatt.survivalgames.thread;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import io.github.m0pt0pmatt.survivalgames.thread.Progressable;
import java.time.Instant;
import java.time.temporal.TemporalAmount;
import java.util.HashSet;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.Executor;
import org.spongepowered.api.text.Text;
import org.spongepowered.api.text.channel.MessageChannel;
import org.spongepowered.api.text.chat.ChatTypes;

public class WatcherRunnable
implements Runnable {
    private final Progressable progressable;
    private final String name;
    private final TemporalAmount timeout;
    private final MessageChannel messageChannel;
    private final Executor executor;

    WatcherRunnable(Progressable progressable, String name, TemporalAmount timeout, MessageChannel messageChannel, Executor executor) {
        this.progressable = (Progressable)Preconditions.checkNotNull((Object)progressable, (Object)"future");
        this.name = (String)Preconditions.checkNotNull((Object)name, (Object)"name");
        this.timeout = timeout;
        this.messageChannel = (MessageChannel)Preconditions.checkNotNull((Object)messageChannel, (Object)"messageChannel");
        this.executor = (Executor)Preconditions.checkNotNull((Object)executor, (Object)"executor");
    }

    @Override
    public void run() {
        Throwable t2;
        HashSet throwable = new HashSet();
        CompletionStage future = CompletableFuture.runAsync(this.progressable, this.executor).handle((r, t) -> {
            throwable.add(t);
            return r;
        });
        Optional<Instant> later = Optional.ofNullable(this.timeout).map(t -> Instant.now().plus((TemporalAmount)t));
        while (true) {
            this.sendMessage();
            if (((CompletableFuture)future).isDone()) break;
            if (later.isPresent() && Instant.now().isAfter(later.get())) {
                this.messageChannel.send((Text)Text.of((String)"Timed out"), ChatTypes.CHAT);
                ((CompletableFuture)future).cancel(true);
                throw new RuntimeException("timeout");
            }
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException e) {
                // empty catch block
                break;
            }
        }
        if ((t2 = (Throwable)throwable.iterator().next()) != null) {
            throw new RuntimeException(t2);
        }
    }

    private void sendMessage() {
        if (!Strings.isNullOrEmpty((String)this.name)) {
            this.messageChannel.send((Text)Text.of((String)(this.name + ": " + this.progressable.getProgress())), ChatTypes.ACTION_BAR);
        }
    }
}

