/*
 * Decompiled with CFR 0.152.
 */
package com.teamacronymcoders.base.materialsystem.parttype;

import com.google.common.collect.Lists;
import com.teamacronymcoders.base.materialsystem.MaterialSystem;
import com.teamacronymcoders.base.materialsystem.MaterialUser;
import com.teamacronymcoders.base.materialsystem.blocks.SubBlockOrePart;
import com.teamacronymcoders.base.materialsystem.materialparts.MaterialPart;
import com.teamacronymcoders.base.materialsystem.partdata.MaterialPartData;
import com.teamacronymcoders.base.materialsystem.parttype.BlockPartType;
import com.teamacronymcoders.base.materialsystem.parttype.PartDataPiece;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.util.ResourceLocation;

public class OrePartType
extends BlockPartType {
    public static final String DROP_DATA_NAME = "drops";
    public static final String VARIANT_DATA_NAME = "variants";

    public OrePartType() {
        super("Ore", OrePartType.setupOreData());
    }

    private static List<PartDataPiece> setupOreData() {
        ArrayList oreDataPieces = Lists.newArrayList();
        oreDataPieces.add(new PartDataPiece(VARIANT_DATA_NAME, false));
        oreDataPieces.add(new PartDataPiece(DROP_DATA_NAME, false));
        return oreDataPieces;
    }

    @Override
    public void setup(@Nonnull MaterialPart materialPart, @Nonnull MaterialUser materialUser) {
        this.createOreSubBlocks(materialPart);
    }

    private void createOreSubBlocks(MaterialPart materialPart) {
        MaterialPartData data = materialPart.getData();
        MaterialUser materialUser = materialPart.getMaterialUser();
        if (data.containsDataPiece(VARIANT_DATA_NAME)) {
            String[] variantNames = data.getDataPiece(VARIANT_DATA_NAME).split(",");
            int[] hardness = this.getArrayForField(data, "hardness");
            int[] resistance = this.getArrayForField(data, "resistance");
            int[] harvestLevel = this.getArrayForField(data, "harvestLevel");
            String[] harvestTool = null;
            String[] drops = null;
            if (data.containsDataPiece("harvestTool")) {
                harvestTool = data.getDataPiece("harvestTool").split(",");
            }
            if (data.containsDataPiece(DROP_DATA_NAME)) {
                drops = data.getDataPiece(DROP_DATA_NAME).split(",");
            }
            for (int i = 0; i < variantNames.length; ++i) {
                String variantName = variantNames[i];
                MaterialPart variantMaterialPart = new MaterialPart(materialPart.getMaterialUser(), materialPart.getMaterial(), materialPart.getPart(), variantName);
                MaterialPartData variantData = variantMaterialPart.getData();
                variantData.addDataValue(VARIANT_DATA_NAME, variantName);
                this.trySetData(hardness, i, "hardness", variantData);
                this.trySetData(resistance, i, "resistance", variantData);
                this.trySetData(harvestLevel, i, "harvestLevel", variantData);
                if (harvestTool != null && harvestTool.length > i) {
                    variantData.addDataValue("harvestTool", harvestTool[i]);
                }
                if (drops != null && drops.length > i) {
                    variantData.addDataValue(DROP_DATA_NAME, drops[i]);
                }
                this.registerSubBlock(materialPart, new SubBlockOrePart(variantMaterialPart, new ResourceLocation(variantName), materialUser));
                variantMaterialPart.setColorized(materialPart.isColorized());
                materialUser.registerMaterialPart(variantMaterialPart);
            }
            MaterialSystem.removeMaterialPart(materialPart);
        } else {
            this.registerSubBlock(materialPart, new SubBlockOrePart(materialPart, new ResourceLocation("stone"), materialUser));
        }
    }

    private void trySetData(int[] numbers, int place, String fieldName, MaterialPartData data) {
        if (numbers != null && numbers.length > place) {
            data.addDataValue(fieldName, Integer.toString(numbers[place]));
        }
    }

    private int[] getArrayForField(MaterialPartData data, String fieldName) {
        int[] returned = null;
        if (data.containsDataPiece(fieldName)) {
            String[] stringPieces = data.getDataPiece(fieldName).split(",");
            returned = new int[stringPieces.length];
            for (int i = 0; i < stringPieces.length; ++i) {
                returned[i] = Integer.parseInt(stringPieces[i]);
            }
        }
        return returned;
    }
}

